/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.config.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.OrmMapperImpl;
import org.nkjmlab.sorm4j.mapping.TypedOrmConnectionImpl;
import org.nkjmlab.sorm4j.util.Try;

public class OrmConnectionImpl
extends OrmMapperImpl
implements OrmConnection {
    public OrmConnectionImpl(Connection connection, OrmConfigStore options) {
        super(connection, options);
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, OrmException::new);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), OrmException::new);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), OrmException::new);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), OrmException::new);
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    @Override
    public void begin() {
        this.begin(2);
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), OrmException::new);
    }

    @Override
    public <T> TypedOrmConnection<T> toTyped(Class<T> objectClass) {
        return new TypedOrmConnectionImpl<T>(objectClass, this.getJdbcConnection(), this.getConfigStore());
    }
}

