/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.config.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.util.Try;

public final class OrmTransaction
extends OrmConnectionImpl {
    OrmTransaction(Connection connection, OrmConfigStore options, int isolationLevel) {
        super(connection, options);
        this.begin(isolationLevel);
    }

    public static OrmTransaction of(Connection conn) {
        return OrmTransaction.of(conn, 2, OrmConfigStore.DEFAULT_CONFIGURATIONS);
    }

    public static OrmTransaction of(Connection conn, int isolationLevel) {
        return OrmTransaction.of(conn, isolationLevel, OrmConfigStore.DEFAULT_CONFIGURATIONS);
    }

    public static OrmTransaction of(Connection connection, int isolationLevel, OrmConfigStore options) {
        return new OrmTransaction(connection, options, isolationLevel);
    }

    public void runTransaction(Consumer<OrmConnection> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        handler.accept(this);
        this.rollback();
    }

    public <R> R executeTransaction(Function<OrmConnection, R> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        R ret = handler.apply(this);
        this.rollback();
        return ret;
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), OrmException::new);
    }

    @Override
    public void close() {
        this.rollback();
        super.close();
    }
}

