/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.config.ResultSetValueGetter;

public class ResultSetConverter {
    private final ResultSetValueGetter resultSetValueGetter;

    public ResultSetConverter(ResultSetValueGetter resultSetValueGetter) {
        this.resultSetValueGetter = resultSetValueGetter;
    }

    public Map<String, Object> toOneMap(ResultSet resultSet, List<String> columns, List<Integer> columnTypes) {
        try {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= columns.size(); ++i) {
                int type = columnTypes.get(i - 1);
                Object value = this.resultSetValueGetter.getValueBySqlType(resultSet, i, type);
                ret.put(columns.get(i - 1), value);
            }
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public final <T> T toOneNativeObject(ResultSet resultSet, Class<T> objectClass) {
        try {
            Object value;
            Object valueT = value = this.resultSetValueGetter.getValueByClass(resultSet, 1, objectClass);
            return (T)valueT;
        }
        catch (SQLException e) {
            throw new OrmException("Fail to get value as [" + objectClass.getSimpleName() + "]", e);
        }
    }

    public final List<Object> toObjectsByClasses(ResultSet resultSet, List<Class<?>> setterParamTypes) {
        try {
            ArrayList<Object> values = new ArrayList<Object>(setterParamTypes.size());
            for (int i = 1; i <= setterParamTypes.size(); ++i) {
                Class<?> type = setterParamTypes.get(i - 1);
                values.add(this.resultSetValueGetter.getValueByClass(resultSet, i, type));
            }
            return values;
        }
        catch (IllegalArgumentException | SecurityException | SQLException e) {
            throw new OrmException(e);
        }
    }

    public Object getValueByClass(ResultSet resultSet, int i, Class<?> classType) throws SQLException {
        return this.resultSetValueGetter.getValueByClass(resultSet, i, classType);
    }
}

