/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SqlFromTableMapping {
    private final String selectByPrimaryKeySql;
    private final String selectAllSql;
    private final String insertSql;
    private final String updateSql;
    private final String deleteSql;
    private final String deleteAllSql;
    private final String mergeSql;
    private final String insertSqlPrefix;
    private final String mergeSqlPrefix;
    private final String insertOrMergePlaceholders;
    private static final Map<String, String> multiRowSqlMap = new ConcurrentHashMap<String, String>();

    SqlFromTableMapping(String tableName, List<String> primaryKeys, List<String> notPrimaryKeys, List<String> autoGeneratedColumns, List<String> notAutoGeneratedColumns, List<String> allColumns) {
        this.insertSqlPrefix = "insert into " + tableName + " (" + this.toColumList(notAutoGeneratedColumns) + ") values";
        this.mergeSqlPrefix = "merge into " + tableName + " (" + this.toColumList(notAutoGeneratedColumns) + ") values";
        this.insertOrMergePlaceholders = " (" + this.generatePlaceholders(notAutoGeneratedColumns.size()) + ") ";
        this.insertSql = this.insertSqlPrefix + this.insertOrMergePlaceholders;
        this.mergeSql = this.mergeSqlPrefix + this.insertOrMergePlaceholders;
        this.selectAllSql = "select " + this.toColumList(allColumns) + " from " + tableName;
        this.selectByPrimaryKeySql = this.selectAllSql + " " + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        this.updateSql = "update " + tableName + this.createUpdateSetClause(notPrimaryKeys) + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        this.deleteSql = "delete from " + tableName + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        this.deleteAllSql = "delete from " + tableName;
    }

    private String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)",", notPrimaryKeys.stream().map(npk -> npk + "=?").collect(Collectors.toList()));
    }

    private String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> pk + "=?").collect(Collectors.toList()));
    }

    private String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }

    private String toColumList(List<String> columns) {
        return String.join((CharSequence)",", columns);
    }

    public String getSelectByPrimaryKeySql() {
        return this.selectByPrimaryKeySql;
    }

    public String getSelectAllSql() {
        return this.selectAllSql;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public String getMultirowInsertSql(int num) {
        return this.getPlaceholders(this.insertSqlPrefix, num);
    }

    public String getMultirowMergeSql(int num) {
        return this.getPlaceholders(this.mergeSqlPrefix, num);
    }

    private String getPlaceholders(String sqlPrefix, int num) {
        return multiRowSqlMap.computeIfAbsent(sqlPrefix + num, n -> sqlPrefix + String.join((CharSequence)",", Stream.generate(() -> this.insertOrMergePlaceholders).limit(num).collect(Collectors.toList())));
    }

    public String getMergeSql() {
        return this.mergeSql;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public String getDeleteAllSql() {
        return this.deleteAllSql;
    }

    public String toString() {
        return "Sql [selectSql=" + this.selectByPrimaryKeySql + ", selectAllSql=" + this.selectAllSql + ", insertSql=" + this.insertSql + ", updateSql=" + this.updateSql + ", deleteSql=" + this.deleteSql + ", mergeSql=" + this.mergeSql + ", insertSqlPrefix=" + this.insertSqlPrefix + ", mergeSqlPrefix=" + this.mergeSqlPrefix + ", insertOrMergePlaceholders=" + this.insertOrMergePlaceholders + "]";
    }
}

