/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.InsertResult;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.config.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.config.PreparedStatementParametersSetter;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.Mapping;
import org.nkjmlab.sorm4j.mapping.MultiRowProcessor;
import org.nkjmlab.sorm4j.mapping.ResultSetConverter;
import org.nkjmlab.sorm4j.mapping.SqlFromTableMapping;
import org.nkjmlab.sorm4j.util.ArrayUtils;
import org.nkjmlab.sorm4j.util.DebugPoint;
import org.nkjmlab.sorm4j.util.DebugPointFactory;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.PreparedStatementUtils;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.nkjmlab.sorm4j.util.Try;
import org.slf4j.Logger;

public final class TableMapping<T>
extends Mapping<T> {
    private static final Logger log = LoggerFactory.getLogger();
    private final Map<String, Class<?>> setterParamTypeMap = new ConcurrentHashMap();
    final PreparedStatementParametersSetter javaToSqlConverter;
    private final String tableName;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final List<String> allColumns;
    private final SqlFromTableMapping sql;
    final MultiRowProcessor<T> batcher;

    private TableMapping(ResultSetConverter sqlToJavaConverter, PreparedStatementParametersSetter javaToSqlConverter, Class<T> objectClass, String tableName, List<Column> columns, ColumnFieldMapper fieldMapper, MultiRowProcessorFactory batchConf, Connection connection) {
        super(sqlToJavaConverter, objectClass, columns, fieldMapper);
        try {
            this.javaToSqlConverter = javaToSqlConverter;
            this.batcher = batchConf.getMultiRowProcessorFactory().apply(this);
            DatabaseMetaData metaData = connection.getMetaData();
            this.tableName = tableName;
            this.primaryKeys = fieldMapper.getPrimaryKeys(metaData, tableName);
            List<Column> _autoGeneratedColumns = fieldMapper.getAutoGeneratedColumns(metaData, tableName);
            this.autoGeneratedColumns = _autoGeneratedColumns.stream().map(c -> c.getName()).collect(Collectors.toList());
            this.autoGeneratedColumnsArray = (String[])this.autoGeneratedColumns.toArray(String[]::new);
            this.notAutoGeneratedColumns = columns.stream().filter(col -> !_autoGeneratedColumns.contains(col)).map(c -> c.getName()).collect(Collectors.toList());
            List<String> notPrimaryKeys = TableMapping.createNoPrimaryKeys(this.primaryKeys, columns).stream().map(c -> c.getName()).collect(Collectors.toList());
            this.columnsForUpdate = new ArrayList(notPrimaryKeys);
            this.columnsForUpdate.addAll(this.primaryKeys);
            this.allColumns = columns.stream().map(c -> c.getName()).collect(Collectors.toList());
            this.sql = new SqlFromTableMapping(tableName, this.primaryKeys, notPrimaryKeys, this.autoGeneratedColumns, this.notAutoGeneratedColumns, this.allColumns);
            if (!StringUtils.equalsSetIgnoreCase(this.allColumns, this.columnToAccessorMap.keySet())) {
                throw new OrmException(StringUtils.format("{} does not match any field. Table [{}] contains Columns {} but [{}] contains Fields {}.", this.allColumns.stream().filter(e -> !this.columnToAccessorMap.keySet().contains(e)).sorted().collect(Collectors.toList()), tableName, columns.stream().sorted().collect(Collectors.toList()), objectClass.getName(), this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList())));
            }
        }
        catch (SQLException e2) {
            throw new OrmException(e2);
        }
    }

    public static final <T> TableMapping<T> createMapping(ResultSetConverter sqlToJavaConverter, PreparedStatementParametersSetter javaToSqlConverter, Class<T> objectClass, String tableName, ColumnFieldMapper fieldMapper, MultiRowProcessorFactory batchConfig, Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            return new TableMapping<T>(sqlToJavaConverter, javaToSqlConverter, objectClass, tableName, fieldMapper.getColumns(metaData, tableName), fieldMapper, batchConfig, connection);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    private static List<Column> createNoPrimaryKeys(List<String> primaryKeys, List<Column> columns) {
        return columns.stream().filter(col -> !primaryKeys.contains(col.getName())).collect(Collectors.toList());
    }

    private Class<?> getSetterParamType(String column) {
        return this.setterParamTypeMap.computeIfAbsent(column, k -> this.columnToAccessorMap.get(column).getSetterParameterType());
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getAllColumns() {
        return this.allColumns;
    }

    public List<String> notAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public SqlFromTableMapping getSql() {
        return this.sql;
    }

    Object[] getInsertParameters(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    Object[] getMergeParameters(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    private Object[] getParametersWithoutAutoGeneratedColumns(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    private Object[] getDeleteParameters(T object) {
        return this.getParameters(object, this.getPrimaryKeys());
    }

    private Object[] getUpdateParameters(T object) {
        return this.getParameters(object, this.columnsForUpdate);
    }

    public Object[] getParameters(Object object, List<String> columns) {
        return columns.stream().map(columnName -> this.getValue(object, (String)columnName)).toArray(Object[]::new);
    }

    private List<Object> setAutoGeneratedKeys(PreparedStatement stmt, T object) {
        ArrayList<Object> arrayList;
        block9: {
            ResultSet resultSet = stmt.getGeneratedKeys();
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                ArrayList<Object> ret = new ArrayList<Object>();
                while (resultSet.next()) {
                    String columnName = metaData.getColumnName(1);
                    Class<?> classType = this.getSetterParamType(columnName);
                    Object value = this.sqlToJavaConverter.getValueByClass(resultSet, 1, classType);
                    this.setValue(object, columnName, value);
                    ret.add(value);
                }
                arrayList = ret;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            resultSet.close();
        }
        return arrayList;
    }

    @SafeVarargs
    final void setPrameters(PreparedStatement stmt, T ... objects) {
        Object[] parameters = Arrays.stream(objects).flatMap(obj -> Arrays.stream(this.getParametersWithoutAutoGeneratedColumns(obj))).toArray(Object[]::new);
        try {
            this.javaToSqlConverter.setParameters(stmt, parameters);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    private int executeUpdate(Connection connection, String sql, Object ... parameters) {
        int n;
        block8: {
            PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(connection, sql);
            try {
                this.javaToSqlConverter.setParameters(stmt, parameters);
                Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.EXECUTE_UPDATE);
                int ret = stmt.executeUpdate();
                dp.ifPresent(sw -> log.debug("{} ExecuteUpdate for one object of [{}] to [{}] Table at [{}] =? [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), this.objectClass.getSimpleName(), this.getTableName(), Try.getOrNull(() -> connection.getMetaData().getURL()), sql}));
                n = ret;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            stmt.close();
        }
        return n;
    }

    public int update(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getUpdateSql(), this.getUpdateParameters(object));
    }

    private void throwExeptionIfPrimaryKeysIsNotExist() {
        if (this.getPrimaryKeys().size() == 0) {
            throw new OrmException("Table " + this.getTableName() + " doesn't have a primary key");
        }
    }

    public int[] update(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getUpdateSql(), obj -> this.getUpdateParameters(obj), objects);
    }

    public int delete(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getDeleteSql(), this.getDeleteParameters(object));
    }

    public int[] delete(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getDeleteSql(), obj -> this.getDeleteParameters(obj), objects);
    }

    public int deleteAll(Connection connection) {
        return this.executeUpdate(connection, this.sql.getDeleteAllSql(), new Object[0]);
    }

    public int insert(Connection connection, T object) {
        return this.executeUpdate(connection, this.sql.getInsertSql(), this.getInsertParameters(object));
    }

    public int merge(Connection connection, T object) {
        return this.executeUpdate(connection, this.sql.getInsertSql(), this.getMergeParameters(object));
    }

    public InsertResult<T> insertAndGetResult(Connection connection, T object) {
        InsertResult<T> insertResult;
        block8: {
            PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(connection, this.sql.getInsertSql(), this.autoGeneratedColumnsArray);
            try {
                this.javaToSqlConverter.setParameters(stmt, this.getInsertParameters(object));
                int rowsModified = stmt.executeUpdate();
                List<Object> keys = this.setAutoGeneratedKeys(stmt, object);
                insertResult = new InsertResult<T>(new int[]{rowsModified}, object, keys);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            stmt.close();
        }
        return insertResult;
    }

    @SafeVarargs
    public final int[] insert(Connection con, T ... objects) {
        return this.batcher.multiRowInsert(con, objects);
    }

    @SafeVarargs
    public final InsertResult<T> insertAndGetResult(Connection con, T ... objects) {
        if (objects == null || objects.length == 0) {
            return InsertResult.empty();
        }
        T[] objsWithoutLast = Arrays.asList(objects).subList(0, objects.length - 1).toArray(Object[]::new);
        T last = objects[objects.length - 1];
        int[] resultWithoutLast = this.insert(con, objsWithoutLast);
        InsertResult<T> insertResult = this.insertAndGetResult(con, last);
        int[] result = ArrayUtils.add(resultWithoutLast, insertResult.getRowsModified()[0]);
        return new InsertResult<T>(result, insertResult.getObject(), insertResult.getAutoGeneratedKeys());
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.batcher.batch(con, sql, parameterCreator, objects);
    }

    public int[] merge(Connection con, T ... objects) {
        int[] result = this.batcher.multiRowMerge(con, objects);
        return result;
    }

    @Override
    public String toString() {
        return "TableMapping [" + super.toString() + "]";
    }

    public String getFormattedString() {
        return "TABLE [" + this.tableName + "] is mapped to [" + this.objectClass.getSimpleName() + "] class. PRIMARY KEY is " + this.primaryKeys + System.lineSeparator() + super.getColumnToAccessorString();
    }
}

