/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.config.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.TypedOrmMapperImpl;
import org.nkjmlab.sorm4j.util.Try;

public class TypedOrmConnectionImpl<T>
extends TypedOrmMapperImpl<T>
implements TypedOrmConnection<T> {
    public TypedOrmConnectionImpl(Class<T> objectClass, Connection connection, OrmConfigStore options) {
        super(objectClass, connection, options);
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, OrmException::new);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), OrmException::new);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), OrmException::new);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), OrmException::new);
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    public void runTransaction(Consumer<TypedOrmConnection<T>> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        handler.accept(this);
        this.rollback();
    }

    public <R> R executeTransaction(Function<TypedOrmConnection<T>, R> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        R ret = handler.apply(this);
        this.rollback();
        return ret;
    }

    @Override
    public void begin() {
        this.begin(2);
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), OrmException::new);
    }

    @Override
    public OrmConnection toUntyped() {
        return OrmConnection.of(this.getJdbcConnection(), this.getConfigStore());
    }
}

