/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.nkjmlab.sorm4j.util.DebugPoint;

public final class DebugPointFactory {
    private static final Map<Name, Boolean> modes = new EnumMap<Name, Boolean>(Name.class);

    public static void setModes(Map<Name, Boolean> map) {
        modes.putAll(map);
    }

    public static void onAll() {
        Arrays.stream(Name.values()).forEach(name -> modes.put((Name)((Object)name), true));
    }

    public static void offAll() {
        Arrays.stream(Name.values()).forEach(name -> modes.put((Name)((Object)name), false));
    }

    public static Optional<DebugPoint> createTempDebugPoint() {
        return DebugPointFactory.createDebugPoint(Name.TEMP);
    }

    public static Optional<DebugPoint> createDebugPoint(Name name) {
        Boolean f = modes.get((Object)name);
        if (f == null || !f.booleanValue()) {
            return Optional.empty();
        }
        DebugPoint dp = new DebugPoint(name.name());
        return Optional.of(dp);
    }

    public static enum Name {
        MAPPING,
        READ,
        LOAD_OBJECT,
        EXECUTE_BATCH,
        EXECUTE_UPDATE,
        TEMP;

    }
}

