/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.helpers.MessageFormatter;

public final class StringUtils {
    private static final ConcurrentMap<String, String> upperCaseCaches = new ConcurrentHashMap<String, String>();

    public static String toUpperCase(String str) {
        String upper = upperCaseCaches.computeIfAbsent(str, key -> key.toUpperCase(Locale.ENGLISH));
        return upper;
    }

    public static String toUpperSnakeCase(String compoundName) {
        String camelCase = compoundName.substring(0, 1).toLowerCase() + compoundName.substring(1);
        return StringUtils.toUpperCase(camelCase.replaceAll("([A-Z])", "_$1"));
    }

    public static List<String> toUpperCase(List<String> names) {
        return names.stream().map(l -> StringUtils.toUpperCase(l)).collect(Collectors.toList());
    }

    public static final List<String> addPluralSuffix(List<String> names) {
        return names.stream().flatMap(name -> List.of(name, name + (Character.isUpperCase(name.charAt(name.length() - 1)) ? "S" : "s")).stream()).collect(Collectors.toList());
    }

    public static boolean containsIgnoreCase(Collection<String> list, String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (String e : list) {
            if (!StringUtils.toUpperCase(e).equals(StringUtils.toUpperCase(str))) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsSetIgnoreCase(Collection<String> set1, Collection<String> set2) {
        return set1.stream().map(s -> StringUtils.toUpperCase(s)).collect(Collectors.toSet()).equals(set2.stream().map(s -> StringUtils.toUpperCase(s)).collect(Collectors.toSet()));
    }

    public static String format(String msg, Object ... params) {
        return MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
    }
}

