package org.nkjmlab.sorm4j.mapping.extension;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.FieldName;


public interface ColumnFieldMapper extends OrmExtension {

  List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  List<Column> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException;

  List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException;


  /**
   * Get field name corresponding to the column name.
   *
   * @param column column name
   * @param fieldNames fieldNames exists in mapped object.
   * @return
   */
  Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames);

  /**
   * Get column name candidates based the field names.
   *
   * @param fieldNames
   * @return
   */
  List<Column> getColumnNameCandidates(List<FieldName> fieldNames);



}
