/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.nkjmlab.sorm4j.mapping.AbstractOrmMapper;
import org.nkjmlab.sorm4j.mapping.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.OrmMapper;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.LazyResultSet;
import org.nkjmlab.sorm4j.sqlstatement.SqlStatement;

class OrmMapperImpl
extends AbstractOrmMapper
implements OrmMapper {
    public OrmMapperImpl(Connection connection, OrmConfigStore defaultConfigurations) {
        super(connection, defaultConfigurations);
    }

    @Override
    public <T> int insert(T object) {
        return this.getCastedTableMapping(object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int insertOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int delete(T object) {
        return this.getCastedTableMapping(object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int deleteOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int update(T object) {
        return this.getCastedTableMapping(object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int updateOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int merge(T object) {
        return this.getCastedTableMapping(object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int mergeOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public <T> int[] delete(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] update(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] merge(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] insert(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> InsertResult<T> insertAndGet(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResult.empty());
    }

    @Override
    public <T> int[] deleteOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] updateOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] mergeOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> int[] insertOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResult.empty());
    }

    @Override
    public <T> int[] delete(List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.delete((T)array));
    }

    private static <T, R> R applytoArray(List<T> objects, Function<T[], R> sqlFunc) {
        return sqlFunc.apply((T[][])objects.toArray(Object[]::new));
    }

    @Override
    public <T> int[] deleteOn(String tableName, List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.deleteOn(tableName, (T)array));
    }

    @Override
    public <T> int[] insert(List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.insert((T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGet(List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.insertAndGet((T)array));
    }

    @Override
    public <T> InsertResult<T> insertAndGetOn(String tableName, List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.insertAndGetOn(tableName, (T)array));
    }

    @Override
    public <T> int[] insertOn(String tableName, List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.insertOn(tableName, (T)array));
    }

    @Override
    public <T> int[] merge(List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.merge((T)array));
    }

    @Override
    public <T> int[] mergeOn(String tableName, List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.mergeOn(tableName, (T)array));
    }

    @Override
    public <T> int[] updateOn(String tableName, List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.updateOn(tableName, (T)array));
    }

    @Override
    public <T> int[] update(List<T> objects) {
        return OrmMapperImpl.applytoArray(objects, array -> this.update((T)array));
    }

    @Override
    public <T> T readByPrimaryKey(Class<T> objectClass, Object ... primaryKeyValues) {
        return this.readByPrimaryKeyAux(objectClass, primaryKeyValues);
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, String sql, Object ... parameters) {
        return this.readListAux(objectClass, sql, parameters);
    }

    @Override
    public final <T> List<T> readAll(Class<T> objectClass) {
        return this.readAllAux(objectClass);
    }

    @Override
    public <T> LazyResultSet<T> readAllLazy(Class<T> objectClass) {
        return this.readAllLazyAux(objectClass);
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, String sql, Object ... parameters) {
        return this.readFirstAux(objectClass, sql, parameters);
    }

    @Override
    public <T> LazyResultSet<T> readLazy(Class<T> objectClass, String sql, Object ... parameters) {
        return this.readLazyAux(objectClass, sql, parameters);
    }

    @Override
    public boolean execute(SqlStatement sql) {
        return this.execute(sql.getSql(), sql.getParameters());
    }

    @Override
    public ResultSet executeQuery(SqlStatement sql) {
        return this.executeQuery(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(SqlStatement sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readFirst(Class<T> objectClass, SqlStatement sql) {
        return this.readFirst(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> LazyResultSet<T> readLazy(Class<T> objectClass, SqlStatement sql) {
        return this.readLazy(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> List<T> readList(Class<T> objectClass, SqlStatement sql) {
        return this.readList(objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapFirst(SqlStatement sql) {
        return this.readMapFirst(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapOne(SqlStatement sql) {
        return this.readMapOne(sql.getSql(), sql.getParameters());
    }

    @Override
    public LazyResultSet<Map<String, Object>> readMapLazy(SqlStatement sql) {
        return this.readMapLazy(sql.getSql(), sql.getParameters());
    }

    @Override
    public List<Map<String, Object>> readMapList(SqlStatement sql) {
        return this.readMapList(sql.getSql(), sql.getParameters());
    }

    @Override
    public <T> T readOne(Class<T> objectClass, String sql, Object ... parameters) {
        return this.readOneAux(objectClass, sql, parameters);
    }

    @Override
    public <T> T readOne(Class<T> objectClass, SqlStatement sql) {
        return this.readOneAux(objectClass, sql.getSql(), sql.getParameters());
    }
}

