/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.mapping.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.TypedOrmMapperImpl;
import org.nkjmlab.sorm4j.sqlstatement.NamedParametersQuery;
import org.nkjmlab.sorm4j.sqlstatement.OrderedParametersQuery;
import org.nkjmlab.sorm4j.sqlstatement.SelectQuery;
import org.nkjmlab.sorm4j.util.Try;

public class TypedOrmConnectionImpl<T>
extends TypedOrmMapperImpl<T>
implements TypedOrmConnection<T> {
    public TypedOrmConnectionImpl(Class<T> objectClass, Connection connection, OrmConfigStore options) {
        super(objectClass, connection, options);
    }

    @Override
    public String getTableName() {
        return this.getTableMapping(this.objectClass).getTableName();
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, OrmException::new);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), OrmException::new);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), OrmException::new);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), OrmException::new);
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    @Override
    public void runTransaction(Consumer<TypedOrmConnection<T>> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        handler.accept(this);
        this.rollback();
    }

    @Override
    public <R> R executeTransaction(Function<TypedOrmConnection<T>, R> handler) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(2);
        R ret = handler.apply(this);
        this.rollback();
        return ret;
    }

    @Override
    public void begin() {
        this.begin(2);
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), OrmException::new);
    }

    @Override
    public SelectQuery<T> createSelectQuery() {
        return new SelectQuery(this);
    }

    @Override
    public NamedParametersQuery<T> createNamedParametersQuery(String sql) {
        return NamedParametersQuery.createFrom(this, sql);
    }

    @Override
    public OrderedParametersQuery<T> createOrderedParametersQuery(String sql) {
        return OrderedParametersQuery.createFrom(this, sql);
    }
}

