/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.nkjmlab.sorm4j.mapping.AbstractOrmMapper;
import org.nkjmlab.sorm4j.mapping.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.mapping.TypedOrmMapper;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.nkjmlab.sorm4j.result.LazyResultSet;
import org.nkjmlab.sorm4j.sqlstatement.SqlStatement;

class TypedOrmMapperImpl<T>
extends AbstractOrmMapper
implements TypedOrmMapper<T> {
    protected Class<T> objectClass;

    public TypedOrmMapperImpl(Class<T> objectClass, Connection connection, OrmConfigStore options) {
        super(connection, options);
        this.objectClass = objectClass;
    }

    @Override
    public T readByPrimaryKey(Object ... primaryKeyValues) {
        return this.readByPrimaryKeyAux(this.objectClass, primaryKeyValues);
    }

    @Override
    public T readFirst(String sql, Object ... parameters) {
        return this.readFirstAux(this.objectClass, sql, parameters);
    }

    @Override
    public LazyResultSet<T> readLazy(String sql, Object ... parameters) {
        return this.readLazyAux(this.objectClass, sql, parameters);
    }

    @Override
    public LazyResultSet<T> readAllLazy() {
        return this.readAllLazyAux(this.objectClass);
    }

    @Override
    public List<T> readList(String sql, Object ... parameters) {
        return this.readListAux(this.objectClass, sql, parameters);
    }

    @Override
    public final List<T> readAll() {
        return this.readAllAux(this.objectClass);
    }

    @Override
    public int insert(T object) {
        return this.getCastedTableMapping(object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public int insertOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).insert(this.getJdbcConnection(), object);
    }

    @Override
    public InsertResult<T> insertAndGet(T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public InsertResult<T> insertAndGetOn(String tableName, T object) {
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, object.getClass());
        return mapping.insertAndGet(this.getJdbcConnection(), object);
    }

    @Override
    public int delete(T object) {
        return this.getCastedTableMapping(object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public int deleteOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).delete(this.getJdbcConnection(), object);
    }

    @Override
    public int update(T object) {
        return this.getCastedTableMapping(object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public int updateOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).update(this.getJdbcConnection(), object);
    }

    @Override
    public int merge(T object) {
        return this.getCastedTableMapping(object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public int mergeOn(String tableName, T object) {
        return this.getCastedTableMapping(tableName, object.getClass()).merge(this.getJdbcConnection(), object);
    }

    @Override
    public int[] delete(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int deleteAll() {
        return this.deleteAll(this.objectClass);
    }

    @Override
    public int[] update(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int[] merge(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int[] insert(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public InsertResult<T> insertAndGet(T ... objects) {
        return this.execSqlIfParameterExists(objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResult.empty());
    }

    @Override
    public int[] deleteOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.delete(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int[] updateOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.update(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int[] mergeOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.merge(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public int[] insertOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insert(this.getJdbcConnection(), objects), () -> new int[0]);
    }

    @Override
    public InsertResult<T> insertAndGetOn(String tableName, T ... objects) {
        return this.execSqlIfParameterExists(tableName, objects, mapping -> mapping.insertAndGet(this.getJdbcConnection(), objects), () -> InsertResult.empty());
    }

    @Override
    public int[] delete(List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.delete((T)array));
    }

    private static <S, R> R applytoArray(List<S> objects, Function<S[], R> sqlFunc) {
        return sqlFunc.apply(objects.toArray(Object[]::new));
    }

    @Override
    public int[] deleteOn(String tableName, List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.deleteOn(tableName, (T)array));
    }

    @Override
    public int[] insert(List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.insert((T)array));
    }

    @Override
    public InsertResult<T> insertAndGet(List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.insertAndGet((T)array));
    }

    @Override
    public InsertResult<T> insertAndGetOn(String tableName, List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.insertAndGetOn(tableName, (T)array));
    }

    @Override
    public int[] insertOn(String tableName, List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.insertOn(tableName, (T)array));
    }

    @Override
    public int[] merge(List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.merge((T)array));
    }

    @Override
    public int[] mergeOn(String tableName, List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.mergeOn(tableName, (T)array));
    }

    @Override
    public int[] updateOn(String tableName, List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.updateOn(tableName, (T)array));
    }

    @Override
    public int[] update(List<T> objects) {
        return TypedOrmMapperImpl.applytoArray(objects, array -> this.update((T)array));
    }

    @Override
    public boolean execute(SqlStatement sql) {
        return this.execute(sql.getSql(), sql.getParameters());
    }

    @Override
    public ResultSet executeQuery(SqlStatement sql) {
        return this.executeQuery(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(SqlStatement sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public T readFirst(SqlStatement sql) {
        return this.readFirst(sql.getSql(), sql.getParameters());
    }

    @Override
    public LazyResultSet<T> readLazy(SqlStatement sql) {
        return this.readLazy(sql.getSql(), sql.getParameters());
    }

    @Override
    public List<T> readList(SqlStatement sql) {
        return this.readList(sql.getSql(), sql.getParameters());
    }

    @Override
    public T readOne(String sql, Object ... parameters) {
        return this.readOneAux(this.objectClass, sql, parameters);
    }

    @Override
    public T readOne(SqlStatement sql) {
        return this.readOneAux(this.objectClass, sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapOne(SqlStatement sql) {
        return this.readMapOne(sql.getSql(), sql.getParameters());
    }

    @Override
    public Map<String, Object> readMapFirst(SqlStatement sql) {
        return this.readMapFirst(sql.getSql(), sql.getParameters());
    }

    @Override
    public LazyResultSet<Map<String, Object>> readMapLazy(SqlStatement sql) {
        return this.readMapLazy(sql.getSql(), sql.getParameters());
    }

    @Override
    public List<Map<String, Object>> readMapList(SqlStatement sql) {
        return this.readMapList(sql.getSql(), sql.getParameters());
    }
}

