/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping.extension;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.FieldName;
import org.nkjmlab.sorm4j.mapping.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.extension.DefaultResultSetConverter;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.slf4j.Logger;

public final class DefaultColumnFieldMapper
implements ColumnFieldMapper {
    private static final Logger log = LoggerFactory.getLogger();

    @Override
    public List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, DefaultColumnFieldMapper.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<Column> columnsList = new ArrayList<Column>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                if (!isAutoIncrement.equals("YES")) continue;
                columnsList.add(new Column(columnName));
            }
            ArrayList<Column> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<Column> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, DefaultColumnFieldMapper.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<Column> columnsList = new ArrayList<Column>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                columnsList.add(new ColumnOnTable(columnName, dataType));
            }
            ArrayList<Column> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<String> primaryKeysList = new ArrayList<String>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, DefaultColumnFieldMapper.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(columnName);
            }
            ArrayList<String> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    private static String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }

    @Override
    public List<Column> getColumnNameCandidates(List<FieldName> fieldNames) {
        return fieldNames.stream().flatMap(fieldName -> this.guessColumnNameCandidates((FieldName)fieldName).stream()).collect(Collectors.toList());
    }

    private List<Column> guessColumnNameCandidates(FieldName fieldName) {
        return List.of(new Column(StringUtils.toUpperSnakeCase(fieldName.getName())), new Column(StringUtils.toUpperCase(fieldName.getName())));
    }

    @Override
    public Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames) {
        for (FieldName fieldName : fieldNames) {
            if (!StringUtils.containsIgnoreCase(this.guessColumnNameCandidates(fieldName).stream().map(s -> s.toString()).collect(Collectors.toList()), column.getName())) continue;
            return Optional.of(fieldName);
        }
        return Optional.empty();
    }

    private static final class ColumnOnTable
    extends Column {
        private int dataType;

        public ColumnOnTable(String name, int dataType) {
            super(name);
            this.dataType = dataType;
        }

        @Override
        public String toString() {
            return this.getName() + "(" + DefaultResultSetConverter.sqlTypeToString(this.dataType) + ")";
        }
    }
}

