/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sqlstatement;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class SqlStatement {
    private final String sql;
    private final Object[] parameters;

    private SqlStatement(String sql, Object ... parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public static SqlStatement of(String sql, Object ... parameters) {
        return new SqlStatement(sql, parameters);
    }

    public String toString() {
        return "sql=[" + this.sql + "]" + (String)(this.parameters == null || this.parameters.length == 0 ? "" : ", parameters=" + Arrays.toString(this.parameters));
    }

    public final String getSql() {
        return this.sql;
    }

    public final Object[] getParameters() {
        return this.parameters;
    }

    public static String literal(Object element) {
        String str;
        if (element == null) {
            return "null";
        }
        if (element instanceof Number || element instanceof Boolean) {
            return element.toString();
        }
        if (element instanceof List) {
            return SqlStatement.joinCommaAndSpace(((List)element).stream().map(e -> SqlStatement.literal(e)).collect(Collectors.toList()));
        }
        switch (str = element.toString()) {
            case "?": {
                return str;
            }
        }
        return SqlStatement.escapeAndWrapSingleQuote(str);
    }

    private static String joinCommaAndSpace(List<String> elements) {
        return String.join((CharSequence)", ", elements);
    }

    private static String escapeAndWrapSingleQuote(String str) {
        return SqlStatement.wrapSingleQuote(str.contains("'") ? str.replaceAll("'", "''") : str);
    }

    private static String wrapSingleQuote(String str) {
        return "'" + str + "'";
    }
}

