/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.util;

import java.util.HashMap;
import java.util.Map;

public final class SqlTypeUtils {
    private static final Map<Integer, String> typeStringMap = SqlTypeUtils.initalizeTypeStringMap();

    private SqlTypeUtils() {
    }

    public static final String sqlTypeToString(int type) {
        return typeStringMap.getOrDefault(type, "");
    }

    private static Map<Integer, String> initalizeTypeStringMap() {
        HashMap<Integer, String> typeStringMap = new HashMap<Integer, String>();
        typeStringMap.put(2003, "ARRAY");
        typeStringMap.put(-5, "BIGINT");
        typeStringMap.put(-2, "BINARY");
        typeStringMap.put(-7, "BIT");
        typeStringMap.put(2004, "BLOB");
        typeStringMap.put(16, "BOOLEAN");
        typeStringMap.put(1, "CHAR");
        typeStringMap.put(2005, "CLOB");
        typeStringMap.put(70, "DATALINK");
        typeStringMap.put(91, "DATE");
        typeStringMap.put(3, "DECIMAL");
        typeStringMap.put(2001, "DISTINCT");
        typeStringMap.put(8, "DOUBLE");
        typeStringMap.put(6, "FLOAT");
        typeStringMap.put(4, "INTEGER");
        typeStringMap.put(2000, "JAVA_OBJECT");
        typeStringMap.put(-4, "LONGVARBINARY");
        typeStringMap.put(-1, "LONGVARCHAR");
        typeStringMap.put(0, "NULL");
        typeStringMap.put(2, "NUMERIC");
        typeStringMap.put(1111, "OTHER");
        typeStringMap.put(7, "REAL");
        typeStringMap.put(2006, "REF");
        typeStringMap.put(-8, "ROWID");
        typeStringMap.put(5, "SMALLINT");
        typeStringMap.put(2002, "STRUCT");
        typeStringMap.put(92, "TIME");
        typeStringMap.put(93, "TIMESTAMP");
        typeStringMap.put(-6, "TINYINT");
        typeStringMap.put(-3, "VARBINARY");
        typeStringMap.put(12, "VARCHAR");
        return typeStringMap;
    }
}

