/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sqlstatement;

import java.util.List;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.core.sqlstatement.SqlStatementImpl;

public interface SqlStatement {
    public String getSql();

    public Object[] getParameters();

    public static SqlStatement of(String sql, Object ... parameters) {
        return new SqlStatementImpl(sql, parameters);
    }

    public static String literal(Object element) {
        String str;
        if (element == null) {
            return "null";
        }
        if (element instanceof Number || element instanceof Boolean) {
            return element.toString();
        }
        if (element instanceof List) {
            return SqlStatement.joinCommaAndSpace(((List)element).stream().map(e -> SqlStatement.literal(e)).collect(Collectors.toList()));
        }
        switch (str = element.toString()) {
            case "?": {
                return str;
            }
        }
        return SqlStatement.escapeAndWrapSingleQuote(str);
    }

    private static String joinCommaAndSpace(List<String> elements) {
        return String.join((CharSequence)", ", elements);
    }

    private static String escapeAndWrapSingleQuote(String str) {
        return SqlStatement.wrapSingleQuote(str.contains("'") ? str.replaceAll("'", "''") : str);
    }

    private static String wrapSingleQuote(String str) {
        return "'" + str + "'";
    }
}

