/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.Configurator;
import org.nkjmlab.sorm4j.ConnectionSource;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.core.connectionsource.DataSourceConnectionSource;
import org.nkjmlab.sorm4j.core.connectionsource.DriverManagerConnectionSource;
import org.nkjmlab.sorm4j.core.mapping.ConfigStore;
import org.nkjmlab.sorm4j.core.mapping.ConfiguratorImpl;
import org.nkjmlab.sorm4j.core.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.core.mapping.SormImpl;
import org.nkjmlab.sorm4j.core.mapping.TypedOrmConnectionImpl;

public final class SormFactory {
    public static final String DEFAULT_CONFIG_NAME = "DEFAULT_CONFIG";

    private static void configure(ConfiguratorImpl configurator, Consumer<Configurator> configuratorConsumer) {
        configuratorConsumer.accept(configurator);
        ConfigStore.refreshAndRegister(configurator.build());
    }

    public static Sorm create(ConnectionSource connectionSource) {
        return SormFactory.create(connectionSource, DEFAULT_CONFIG_NAME);
    }

    public static Sorm create(ConnectionSource connectionSource, String configName) {
        return new SormImpl(connectionSource, ConfigStore.get(configName));
    }

    public static Sorm create(DataSource dataSource) {
        return SormFactory.create(dataSource, DEFAULT_CONFIG_NAME);
    }

    public static Sorm create(DataSource dataSource, String configName) {
        return SormFactory.create(SormFactory.createConnectionSource(dataSource), configName);
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return SormFactory.create(jdbcUrl, user, password, DEFAULT_CONFIG_NAME);
    }

    public static Sorm create(String jdbcUrl, String user, String password, String configName) {
        return SormFactory.create(SormFactory.createConnectionSource(jdbcUrl, user, password), configName);
    }

    private static ConnectionSource createConnectionSource(DataSource dataSource) {
        return new DataSourceConnectionSource(dataSource);
    }

    private static ConnectionSource createConnectionSource(String jdbcUrl, String user, String password) {
        return new DriverManagerConnectionSource(jdbcUrl, user, password);
    }

    public static void registerConfig(String configName, Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(configName), configuratorConsumer);
    }

    public static void registerModifiedConfig(String configName, Sorm sorm, Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(configName, sorm.getConfigStore()), configuratorConsumer);
    }

    public static void updateDefaultConfig(Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(DEFAULT_CONFIG_NAME), configuratorConsumer);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return SormFactory.toOrmConnection(connection, ConfigStore.getDefaultConfigStore());
    }

    public static <T> TypedOrmConnection<T> toOrmConnection(Connection conn, Class<T> objectClass) {
        return SormFactory.toOrmConnection(conn, objectClass, ConfigStore.getDefaultConfigStore());
    }

    private static <T> TypedOrmConnection<T> toOrmConnection(Connection connection, Class<T> objectClass, ConfigStore configStore) {
        return new TypedOrmConnectionImpl<T>(objectClass, connection, configStore);
    }

    public static <T> TypedOrmConnection<T> toOrmConnection(Connection conn, Class<T> objectClass, String configName) {
        return SormFactory.toOrmConnection(conn, objectClass, ConfigStore.get(configName));
    }

    private static OrmConnection toOrmConnection(Connection connection, ConfigStore configStore) {
        return new OrmConnectionImpl(connection, configStore);
    }

    public static OrmConnection toOrmConnection(Connection connection, String configName) {
        return SormFactory.toOrmConnection(connection, ConfigStore.get(configName));
    }

    private SormFactory() {
    }
}

