/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.OrmLogger;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.core.mapping.AbstractOrmMapper;
import org.nkjmlab.sorm4j.core.mapping.InsertResultImpl;
import org.nkjmlab.sorm4j.core.mapping.Mapping;
import org.nkjmlab.sorm4j.core.mapping.SqlFromTableMapping;
import org.nkjmlab.sorm4j.core.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.core.mapping.multirow.MultiRowProcessorGeneratorFactory;
import org.nkjmlab.sorm4j.core.util.ArrayUtils;
import org.nkjmlab.sorm4j.core.util.LogPoint;
import org.nkjmlab.sorm4j.core.util.LogPointFactory;
import org.nkjmlab.sorm4j.core.util.LoggerFactory;
import org.nkjmlab.sorm4j.core.util.StringUtils;
import org.nkjmlab.sorm4j.core.util.Try;
import org.nkjmlab.sorm4j.extension.Column;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.result.InsertResult;
import org.slf4j.Logger;

public final class TableMapping<T>
extends Mapping<T> {
    private static final Logger log = LoggerFactory.getLogger();
    private final Map<String, Class<?>> setterParamTypeMap = new ConcurrentHashMap();
    private final SqlParameterSetter sqlParameterSetter;
    private final String tableName;
    private final List<String> primaryKeys;
    private final List<String> autoGeneratedColumns;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final List<String> allColumns;
    private final SqlFromTableMapping sql;
    private final MultiRowProcessor<T> multiRowProcessor;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;

    private TableMapping(ResultSetConverter sqlToJavaConverter, SqlParameterSetter javaToSqlConverter, Class<T> objectClass, String tableName, List<Column> columns, ColumnFieldMapper fieldMapper, MultiRowProcessorGeneratorFactory multiRowProcessorGeneratorFactory, Connection connection) throws SQLException {
        super(sqlToJavaConverter, objectClass, columns, fieldMapper);
        this.sqlParameterSetter = javaToSqlConverter;
        MultiRowProcessor<?> processor = multiRowProcessorGeneratorFactory.getMultiRowProcessorFunction().apply(this);
        this.multiRowProcessor = processor;
        DatabaseMetaData metaData = connection.getMetaData();
        this.tableName = tableName;
        this.primaryKeys = fieldMapper.getPrimaryKeys(metaData, tableName).stream().map(c -> c.getName()).collect(Collectors.toList());
        this.hasPrimaryKey = this.getPrimaryKeys().size() != 0;
        List<Column> _autoGeneratedColumns = fieldMapper.getAutoGeneratedColumns(metaData, tableName);
        this.autoGeneratedColumns = _autoGeneratedColumns.stream().map(c -> c.getName()).collect(Collectors.toList());
        this.autoGeneratedColumnsArray = (String[])this.autoGeneratedColumns.toArray(String[]::new);
        this.hasAutoGeneratedColumns = this.autoGeneratedColumns.size() != 0;
        this.notAutoGeneratedColumns = columns.stream().filter(col -> !_autoGeneratedColumns.contains(col)).map(c -> c.getName()).collect(Collectors.toList());
        List<String> notPrimaryKeys = TableMapping.createNoPrimaryKeys(this.primaryKeys, columns).stream().map(c -> c.getName()).collect(Collectors.toList());
        this.columnsForUpdate = new ArrayList(notPrimaryKeys);
        this.columnsForUpdate.addAll(this.primaryKeys);
        this.allColumns = columns.stream().map(c -> c.getName()).collect(Collectors.toList());
        this.sql = new SqlFromTableMapping(tableName, this.primaryKeys, notPrimaryKeys, this.autoGeneratedColumns, this.notAutoGeneratedColumns, this.allColumns);
        if (!StringUtils.equalsSetIgnoreCase(this.allColumns, this.columnToAccessorMap.keySet())) {
            throw new SormException(StringUtils.format("{} does not match any field. Table [{}] contains Columns {} but [{}] contains Fields {}.", this.allColumns.stream().filter(e -> !this.columnToAccessorMap.keySet().contains(e)).sorted().collect(Collectors.toList()), tableName, columns.stream().sorted().collect(Collectors.toList()), objectClass.getName(), this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList())));
        }
    }

    public static final <T> TableMapping<T> createMapping(ResultSetConverter sqlToJavaConverter, SqlParameterSetter javaToSqlConverter, Class<T> objectClass, String tableName, ColumnFieldMapper fieldMapper, MultiRowProcessorGeneratorFactory batchConfig, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return new TableMapping<T>(sqlToJavaConverter, javaToSqlConverter, objectClass, tableName, fieldMapper.getColumns(metaData, tableName), fieldMapper, batchConfig, connection);
    }

    private static List<Column> createNoPrimaryKeys(List<String> primaryKeys, List<Column> columns) {
        return columns.stream().filter(col -> !primaryKeys.contains(col.getName())).collect(Collectors.toList());
    }

    private Class<?> getSetterParamType(String column) {
        return this.setterParamTypeMap.computeIfAbsent(column, k -> this.columnToAccessorMap.get(column).getSetterParameterType());
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getAllColumns() {
        return this.allColumns;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public SqlFromTableMapping getSql() {
        return this.sql;
    }

    public Object[] getInsertParameters(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    public Object[] getMergeParameters(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    private Object[] getParametersWithoutAutoGeneratedColumns(T object) {
        return this.getParameters(object, this.notAutoGeneratedColumns);
    }

    private Object[] getDeleteParameters(T object) {
        return this.getParameters(object, this.getPrimaryKeys());
    }

    private Object[] getUpdateParameters(T object) {
        return this.getParameters(object, this.columnsForUpdate);
    }

    public Object[] getParameters(Object object, List<String> columns) {
        if (object == null) {
            throw new SormException(StringUtils.format("Fail to get value from a instance of [{}] but it is null.", this.getObjectClass()));
        }
        return columns.stream().map(columnName -> this.getValue(object, (String)columnName)).toArray(Object[]::new);
    }

    private List<Object> setAutoGeneratedKeys(PreparedStatement stmt, T object) throws SQLException {
        try (ResultSet resultSet = stmt.getGeneratedKeys();){
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Object> ret = new ArrayList<Object>();
            while (resultSet.next()) {
                String columnName = metaData.getColumnName(1);
                Class<?> classType = this.getSetterParamType(columnName);
                Object value = this.resultSetConverter.getValueBySetterParameterType(resultSet, 1, classType);
                this.setValue(object, columnName, value);
                ret.add(value);
            }
            ArrayList<Object> arrayList = ret;
            return arrayList;
        }
    }

    @SafeVarargs
    public final void setPrameters(PreparedStatement stmt, T ... objects) throws SQLException, IOException {
        Object[] parameters = Arrays.stream(objects).flatMap(obj -> Arrays.stream(this.getParametersWithoutAutoGeneratedColumns(obj))).toArray(Object[]::new);
        this.sqlParameterSetter.setParameters(stmt, parameters);
    }

    private int executeUpdate(Connection connection, String sql, Object ... parameters) {
        Optional<LogPoint> dp = LogPointFactory.createLogPoint(OrmLogger.Category.EXECUTE_UPDATE);
        dp.ifPresent(lp -> log.debug("[{}] [{}] with {} parameters", new Object[]{lp.getTag(), sql, parameters == null ? 0 : parameters.length}));
        int ret = AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, connection, sql, parameters, stmt -> stmt.executeUpdate());
        dp.ifPresent(lp -> {
            log.trace("[{}] Parameters = {}", (Object)lp.getTag(), (Object)parameters);
            log.debug("{} Call executeUpdate for [{}] to [{}] Table at [{}]", new Object[]{lp.getTagAndElapsedTime(), this.getObjectClass().getSimpleName(), this.getTableName(), Try.getOrNull(() -> connection.getMetaData().getURL()), sql});
        });
        return ret;
    }

    public int update(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getUpdateSql(), this.getUpdateParameters(object));
    }

    public void throwExeptionIfPrimaryKeysIsNotExist() {
        if (!this.hasPrimaryKey) {
            throw new SormException("This opperation requiers primary keys but Table [" + this.getTableName() + "] doesn't have them.");
        }
    }

    public void throwExeptionIfAutoGeneratedColumnsExist() {
        if (this.hasAutoGeneratedColumns) {
            throw new SormException("This opperation requiers no autogenerated columns but Table [" + this.getTableName() + "] has them.");
        }
    }

    public int[] update(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getUpdateSql(), obj -> this.getUpdateParameters(obj), objects);
    }

    public int delete(Connection connection, T object) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.executeUpdate(connection, this.getSql().getDeleteSql(), this.getDeleteParameters(object));
    }

    public int[] delete(Connection connection, T ... objects) {
        this.throwExeptionIfPrimaryKeysIsNotExist();
        return this.batch(connection, this.sql.getDeleteSql(), obj -> this.getDeleteParameters(obj), objects);
    }

    public int deleteAll(Connection connection) {
        return this.executeUpdate(connection, this.sql.getDeleteAllSql(), new Object[0]);
    }

    public int insert(Connection connection, T object) {
        return this.executeUpdate(connection, this.sql.getInsertSql(), this.getInsertParameters(object));
    }

    public int merge(Connection connection, T object) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        return this.executeUpdate(connection, this.sql.getMergeSql(), this.getMergeParameters(object));
    }

    public InsertResult<T> insertAndGet(Connection connection, T object) {
        InsertResultImpl<T> insertResultImpl;
        block8: {
            String insertSql = this.sql.getInsertSql();
            Optional<LogPoint> dp = LogPointFactory.createLogPoint(OrmLogger.Category.EXECUTE_UPDATE);
            dp.ifPresent(lp -> log.debug("[{}] [{}]", (Object)lp.getTag(), (Object)insertSql));
            PreparedStatement stmt = this.autoGeneratedColumnsArray == null || this.autoGeneratedColumnsArray.length == 0 ? connection.prepareStatement(insertSql) : connection.prepareStatement(insertSql, this.autoGeneratedColumnsArray);
            try {
                this.sqlParameterSetter.setParameters(stmt, this.getInsertParameters(object));
                int rowsModified = stmt.executeUpdate();
                List<Object> keys = this.setAutoGeneratedKeys(stmt, object);
                dp.ifPresent(lp -> {
                    log.trace("[{}] Parameter = {}", (Object)lp.getTag(), object);
                    log.debug("{} Call executeUpdate for [{}] to [{}] Table at [{}]", new Object[]{lp.getTagAndElapsedTime(), this.getObjectClass().getSimpleName(), this.getTableName(), Try.getOrNull(() -> connection.getMetaData().getURL()), insertSql});
                });
                insertResultImpl = new InsertResultImpl<T>(new int[]{rowsModified}, object, keys);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            stmt.close();
        }
        return insertResultImpl;
    }

    @SafeVarargs
    public final int[] insert(Connection con, T ... objects) {
        return this.multiRowProcessor.multiRowInsert(con, objects);
    }

    @SafeVarargs
    public final InsertResult<T> insertAndGet(Connection con, T ... objects) {
        T[] objsWithoutLast = Arrays.asList(objects).subList(0, objects.length - 1).toArray(Object[]::new);
        T last = objects[objects.length - 1];
        int[] resultWithoutLast = this.insert(con, objsWithoutLast);
        InsertResult<T> insertResult = this.insertAndGet(con, last);
        int[] result = ArrayUtils.add(resultWithoutLast, insertResult.getRowsModified()[0]);
        return new InsertResultImpl<T>(result, insertResult.getObject(), insertResult.getAutoGeneratedKeys());
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.multiRowProcessor.batch(con, sql, parameterCreator, objects);
    }

    public int[] merge(Connection con, T ... objects) {
        this.throwExeptionIfAutoGeneratedColumnsExist();
        int[] result = this.multiRowProcessor.multiRowMerge(con, objects);
        return result;
    }

    public String getFormattedString() {
        return "[" + TableMapping.class.getSimpleName() + "] TABLE [" + this.tableName + "] is mapped to [" + this.getObjectClass().getSimpleName() + "] class. PRIMARY KEY is " + this.primaryKeys + System.lineSeparator() + super.getColumnToAccessorString() + System.lineSeparator() + "[" + this.multiRowProcessor.getClass().getSimpleName() + "] is used for processing multirow.";
    }
}

