/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.FunctionHandler;
import org.nkjmlab.sorm4j.OrmLogger;
import org.nkjmlab.sorm4j.ResultSetMapper;
import org.nkjmlab.sorm4j.RowMapper;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.SqlExecutor;
import org.nkjmlab.sorm4j.core.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.core.mapping.ConfigStore;
import org.nkjmlab.sorm4j.core.mapping.LazyResultSetImpl;
import org.nkjmlab.sorm4j.core.mapping.TableMapping;
import org.nkjmlab.sorm4j.core.mapping.multirow.MultiRowProcessorGeneratorFactory;
import org.nkjmlab.sorm4j.core.util.LogPoint;
import org.nkjmlab.sorm4j.core.util.LogPointFactory;
import org.nkjmlab.sorm4j.core.util.LoggerFactory;
import org.nkjmlab.sorm4j.core.util.StringUtils;
import org.nkjmlab.sorm4j.core.util.Try;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.sql.LazyResultSet;
import org.nkjmlab.sorm4j.sql.SqlStatement;
import org.slf4j.Logger;

abstract class AbstractOrmMapper
implements SqlExecutor,
ResultSetMapper {
    private static final Logger log = LoggerFactory.getLogger();
    private final ColumnFieldMapper fieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetConverter resultSetConverter;
    private final SqlParameterSetter sqlParameterSetter;
    private final Connection connection;
    private final MultiRowProcessorGeneratorFactory batchConfig;
    private final ConfigStore configStore;
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private final int transactionIsolationLevel;

    private static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnName(i));
            columnTypes.add(metaData.getColumnType(i));
        }
        return new ColumnsAndTypes(columns, columnTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final <R> R execPreparedStatementAndClose(SqlParameterSetter sqlParameterSetter, Connection connection, String sql, Object[] parameters, Try.ThrowableFunction<PreparedStatement, R> func) {
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            sqlParameterSetter.setParameters(stmt, parameters);
            R r = func.apply(stmt);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public AbstractOrmMapper(Connection connection, ConfigStore configStore) {
        this.connection = connection;
        this.configStore = configStore;
        this.batchConfig = configStore.getMultiRowProcessorGeneratorFactory();
        this.fieldMapper = configStore.getColumnFieldMapper();
        this.tableNameMapper = configStore.getTableNameMapper();
        this.resultSetConverter = configStore.getResultSetConverter();
        this.sqlParameterSetter = configStore.getSqlParameterSetter();
        this.tableMappings = configStore.getTableMappings();
        this.columnsMappings = configStore.getColumnsMappings();
        this.classNameToValidTableNameMap = configStore.getClassNameToValidTableNameMap();
        this.tableNameToValidTableNameMap = configStore.getTableNameToValidTableNameMaps();
        this.transactionIsolationLevel = configStore.getTransactionIsolationLevel();
    }

    public <T> int deleteAll(Class<T> objectClass) {
        return this.getTableMapping(objectClass).deleteAll(this.connection);
    }

    public int deleteAllOn(String tableName) {
        return this.executeUpdate("DELETE FROM " + tableName, new Object[0]);
    }

    protected final <T, R> R execSqlIfParameterExists(String tableName, T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    protected final <T, R> R execSqlIfParameterExists(T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> R execStatementAndReadResultSet(String sql, Object[] parameters, FunctionHandler<ResultSet, R> resultSetHandler) {
        Optional<LogPoint> dp = LogPointFactory.createLogPoint(OrmLogger.Category.EXECUTE_QUERY);
        dp.ifPresent(lp -> {
            log.debug("[{}] [{}] with {} parameters", new Object[]{lp.getTag(), sql, parameters == null ? 0 : parameters.length});
            log.trace("[{}] Parameters = {}", (Object)lp.getTag(), (Object)parameters);
        });
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            Object r;
            block14: {
                this.sqlParameterSetter.setParameters(stmt, parameters);
                ResultSet resultSet = stmt.executeQuery();
                try {
                    Object ret = resultSetHandler.apply(resultSet);
                    dp.ifPresent(sw -> log.debug("{} Read [{}] objects from [{}]", new Object[]{sw.getTagAndElapsedTime(), ret instanceof Collection ? ((Collection)ret).size() : 1, Try.getOrNull(() -> this.connection.getMetaData().getURL())}));
                    r = ret;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            String msg = parameters == null || parameters.length == 0 ? StringUtils.format("Error in sql=[{}]", sql) : StringUtils.format("Fail to execute sql=[{}], parameters={}", sql, parameters);
            throw new SormException(msg + System.lineSeparator() + e.getMessage(), e);
        }
    }

    @Override
    public <T> T executeQuery(SqlStatement sql, FunctionHandler<ResultSet, T> resultSetHandler) {
        return this.execStatementAndReadResultSet(sql.getSql(), sql.getParameters(), resultSetHandler);
    }

    @Override
    public <T> List<T> executeQuery(SqlStatement sql, RowMapper<T> rowMapper) {
        return this.execStatementAndReadResultSet(sql.getSql(), sql.getParameters(), ResultSetMapper.convertToRowsMapper(rowMapper));
    }

    @Override
    public int executeUpdate(SqlStatement sql) {
        return this.executeUpdate(sql.getSql(), sql.getParameters());
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        Optional<LogPoint> dp = LogPointFactory.createLogPoint(OrmLogger.Category.EXECUTE_UPDATE);
        int ret = AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, this.connection, sql, parameters, stmt -> stmt.executeUpdate());
        dp.ifPresent(sw -> {
            log.debug("{} Call [{}] [{}]", new Object[]{sw.getTagAndElapsedTime(), sql, Try.getOrNull(() -> this.connection.getMetaData().getURL()), sql});
            log.trace("[{}] Parameters = {} ", (Object)sw.getTag(), (Object)parameters);
        });
        return ret;
    }

    protected <T> TableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.getTableMapping(objectClass);
    }

    protected <T> TableMapping<T> getCastedTableMapping(String tableName, Class<?> objectClass) {
        return this.getTableMapping(tableName, objectClass);
    }

    <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = ColumnsMapping.createMapping(objectClass, this.resultSetConverter, this.fieldMapper);
            LogPointFactory.createLogPoint(OrmLogger.Category.MAPPING).ifPresent(lp -> log.info(System.lineSeparator() + m.getFormattedString()));
            return m;
        });
        return ret;
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    public <T> TableMapping<T> getTableMapping(Class<T> objectClass) {
        TableName tableName = this.toTableName(objectClass);
        return this.getTableMapping(tableName, objectClass);
    }

    <T> TableMapping<T> getTableMapping(String tableName, Class<T> objectClass) {
        return this.getTableMapping(this.toTableName(tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = TableMapping.createMapping(this.resultSetConverter, this.sqlParameterSetter, objectClass, tableName.getName(), this.fieldMapper, this.batchConfig, this.connection);
            LogPointFactory.createLogPoint(OrmLogger.Category.MAPPING).ifPresent(lp -> log.info("[{}]" + System.lineSeparator() + "{}", (Object)lp.getTag(), (Object)m.getFormattedString()));
            return m;
        }, Try::rethrow));
        return ret;
    }

    protected int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return this.mapRowAux(objectClass, resultSet);
        }
        return null;
    }

    Map<String, Object> loadFirstMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.mapRowAux(resultSet);
        }
        return ret;
    }

    private final <T> List<T> loadNativeObjectList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        Try.runOrThrow(() -> {
            ResultSetMetaData metaData = resultSet.getMetaData();
            if (metaData.getColumnCount() != 1) {
                throw new SormException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
            }
        }, Try::rethrow);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.resultSetConverter.toSingleNativeObject(resultSet, objectClass));
        }
        return ret;
    }

    <T> T loadOne(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        T ret = null;
        if (resultSet.next()) {
            ret = this.mapRowAux(objectClass, resultSet);
        }
        if (resultSet.next()) {
            throw new RuntimeException("Non-unique result returned");
        }
        return ret;
    }

    Map<String, Object> loadOneMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.mapRowAux(resultSet);
        }
        if (resultSet.next()) {
            throw new SormException("Non-unique result returned");
        }
        return ret;
    }

    public final <T> List<T> loadPojoList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojoList(resultSet);
    }

    public <T> T mapRowAux(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.resultSetConverter.isEnableToConvertNativeObject(objectClass) ? this.resultSetConverter.toSingleNativeObject(resultSet, objectClass) : this.toSinglePojo(objectClass, resultSet);
    }

    public Map<String, Object> mapRowAux(ResultSet resultSet) throws SQLException {
        ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
        return this.resultSetConverter.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes());
    }

    public final <T> List<T> mapRowsAux(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return this.resultSetConverter.isEnableToConvertNativeObject(objectClass) ? this.loadNativeObjectList(objectClass, resultSet) : this.loadPojoList(objectClass, resultSet);
    }

    public final List<Map<String, Object>> mapRowsAux(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
        while (resultSet.next()) {
            ret.add(this.resultSetConverter.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes()));
        }
        return ret;
    }

    @Override
    public <T> T mapRow(Class<T> objectClass, ResultSet resultSet) {
        return (T)Try.getOrThrow(() -> this.mapRowAux(objectClass, resultSet), Try::rethrow);
    }

    @Override
    public Map<String, Object> mapRow(ResultSet resultSet) {
        return Try.getOrThrow(() -> this.mapRowAux(resultSet), Try::rethrow);
    }

    @Override
    public final <T> List<T> mapRows(Class<T> objectClass, ResultSet resultSet) {
        return Try.getOrThrow(() -> this.mapRowsAux(objectClass, resultSet), Try::rethrow);
    }

    @Override
    public final List<Map<String, Object>> mapRows(ResultSet resultSet) {
        return Try.getOrThrow(() -> this.mapRowsAux(resultSet), Try::rethrow);
    }

    final <T> List<T> readAllAux(Class<T> objectClass) {
        return this.readListAux(objectClass, this.getCastedTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    final <T> LazyResultSet<T> readAllLazyAux(Class<T> objectClass) {
        return this.readLazyAux(objectClass, this.getTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    final <T> T readByPrimaryKeyAux(Class<T> objectClass, Object ... primaryKeyValues) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        mapping.throwExeptionIfPrimaryKeysIsNotExist();
        String sql = mapping.getSql().getSelectByPrimaryKeySql();
        return this.readFirstAux(objectClass, sql, primaryKeyValues);
    }

    final <T> T readFirstAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execStatementAndReadResultSet(sql, parameters, resultSet -> this.loadFirst(objectClass, (ResultSet)resultSet));
    }

    final <T> LazyResultSet<T> readLazyAux(Class<T> objectClass, String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.sqlParameterSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            return new LazyResultSetImpl<T>(this, objectClass, stmt, resultSet);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    final <T> List<T> readListAux(Class<T> objectClass, String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> this.mapRowsAux(objectClass, (ResultSet)resultSet));
    }

    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
            if (resultSet.next()) {
                return this.resultSetConverter.toSingleMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            return null;
        });
    }

    public LazyResultSet<Map<String, Object>> readMapLazy(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            this.sqlParameterSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            LazyResultSetImpl<Map<String, Object>> ret = new LazyResultSetImpl<Map<String, Object>>(this, LinkedHashMap.class, stmt, resultSet);
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> this.mapRowsAux((ResultSet)resultSet));
    }

    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
            Map<String, Object> ret = null;
            if (resultSet.next()) {
                ret = this.resultSetConverter.toSingleMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    final <T> T readOneAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            Object ret = null;
            if (resultSet.next()) {
                ret = this.mapRowAux(objectClass, (ResultSet)resultSet);
            }
            if (resultSet.next()) {
                throw new SormException("Non-unique result returned");
            }
            return ret;
        });
    }

    private final <T> T toSinglePojo(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojo(resultSet);
    }

    private TableName toTableName(Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, Try.createFunctionWithThrow(k -> this.tableNameMapper.getTableName(objectClass, this.connection.getMetaData()), Try::rethrow));
    }

    private TableName toTableName(String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, Try.createFunctionWithThrow(k -> this.tableNameMapper.getTableName(tableName, this.connection.getMetaData()), Try::rethrow));
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        public ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

