/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping;

import java.sql.Connection;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.core.mapping.ConfigStore;
import org.nkjmlab.sorm4j.core.mapping.OrmMapperImpl;
import org.nkjmlab.sorm4j.core.mapping.TypedOrmConnectionImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.NamedParameterQueryImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.OrderedParameterQueryImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.QueryOrmExecutor;
import org.nkjmlab.sorm4j.core.sqlstatement.SelectQueryImpl;
import org.nkjmlab.sorm4j.core.util.Try;
import org.nkjmlab.sorm4j.sql.NamedParameterQuery;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.OrderedParameterQuery;
import org.nkjmlab.sorm4j.sql.OrderedParameterSql;
import org.nkjmlab.sorm4j.sql.SelectQuery;

public class OrmConnectionImpl
extends OrmMapperImpl
implements OrmConnection {
    public OrmConnectionImpl(Connection connection, ConfigStore options) {
        super(connection, options);
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, Try::rethrow);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), Try::rethrow);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), Try::rethrow);
    }

    @Override
    public void begin(int isolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(isolationLevel);
    }

    @Override
    public void begin() {
        this.begin(this.getTransactionIsolationLevel());
    }

    private void setTransactionIsolation(int isolationLevel) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(isolationLevel), Try::rethrow);
    }

    @Override
    public NamedParameterSql createNamedParameterSql(String sql) {
        return NamedParameterSql.from(sql);
    }

    @Override
    public OrderedParameterSql createOrderedParameterSql(String sql) {
        return OrderedParameterSql.from(sql);
    }

    public <S> TypedOrmConnection<S> type(Class<S> objectClass) {
        return new TypedOrmConnectionImpl<S>(objectClass, this.getJdbcConnection(), this.getConfigStore());
    }

    @Override
    public <T> SelectQuery<T> createSelectQuery(Class<T> objectClass) {
        SelectQueryImpl<T> ret = new SelectQueryImpl<T>(new QueryOrmExecutor<T>(this, objectClass));
        ret.from(this.getTableMapping((Class)objectClass).getTableName());
        return ret;
    }

    @Override
    public <T> NamedParameterQuery<T> createNamedParameterQuery(Class<T> objectClass, String sql) {
        return NamedParameterQueryImpl.createFrom(new QueryOrmExecutor<T>(this, objectClass), sql);
    }

    @Override
    public <T> OrderedParameterQuery<T> createOrderedParameterQuery(Class<T> objectClass, String sql) {
        return OrderedParameterQueryImpl.createFrom(new QueryOrmExecutor<T>(this, objectClass), sql);
    }
}

