/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping;

import java.sql.Connection;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.core.mapping.ConfigStore;
import org.nkjmlab.sorm4j.core.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.core.mapping.TypedOrmMapperImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.NamedParameterQueryImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.OrderedParameterQueryImpl;
import org.nkjmlab.sorm4j.core.sqlstatement.QueryTypedOrmExecutor;
import org.nkjmlab.sorm4j.core.sqlstatement.SelectQueryImpl;
import org.nkjmlab.sorm4j.core.util.Try;
import org.nkjmlab.sorm4j.sql.NamedParameterQuery;
import org.nkjmlab.sorm4j.sql.OrderedParameterQuery;
import org.nkjmlab.sorm4j.sql.SelectQuery;

public class TypedOrmConnectionImpl<T>
extends TypedOrmMapperImpl<T>
implements TypedOrmConnection<T> {
    public TypedOrmConnectionImpl(Class<T> objectClass, Connection connection, ConfigStore options) {
        super(objectClass, connection, options);
    }

    @Override
    public String getTableName() {
        return this.getTableMapping(this.objectClass).getTableName();
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, Try::rethrow);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), Try::rethrow);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), Try::rethrow);
    }

    @Override
    public void begin(int transactionIsolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(transactionIsolationLevel);
    }

    @Override
    public void begin() {
        this.begin(this.getTransactionIsolationLevel());
    }

    private void setTransactionIsolation(int level) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(level), Try::rethrow);
    }

    @Override
    public SelectQuery<T> createSelectQuery() {
        SelectQueryImpl ret = new SelectQueryImpl(new QueryTypedOrmExecutor(this));
        ret.from(this.getTableName());
        return ret;
    }

    @Override
    public NamedParameterQuery<T> createNamedParameterQuery(String sql) {
        return NamedParameterQueryImpl.createFrom(new QueryTypedOrmExecutor(this), sql);
    }

    @Override
    public OrderedParameterQuery<T> createOrderedParameterQuery(String sql) {
        return OrderedParameterQueryImpl.createFrom(new QueryTypedOrmExecutor(this), sql);
    }

    @Override
    public <S> TypedOrmConnection<S> type(Class<S> objectClass) {
        return new TypedOrmConnectionImpl<S>(objectClass, this.getJdbcConnection(), this.getConfigStore());
    }

    @Override
    public OrmConnection untype() {
        return new OrmConnectionImpl(this.getJdbcConnection(), this.getConfigStore());
    }
}

