/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    @SafeVarargs
    public static <T> List<T[]> split(int size, T ... objects) {
        int slotNum = Math.floorDiv(objects.length, size);
        ArrayList<T[]> result = new ArrayList<T[]>(slotNum + 1);
        for (int i = 0; i < slotNum; ++i) {
            result.add(Arrays.copyOfRange(objects, size * i, size * (i + 1)));
        }
        if (size * slotNum != objects.length) {
            result.add(Arrays.copyOfRange(objects, size * slotNum, objects.length));
        }
        return result;
    }

    public static int[] add(int[] array, int i) {
        int arrayLength = Array.getLength(array);
        int[] newArray = new int[arrayLength + 1];
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        newArray[arrayLength] = i;
        return newArray;
    }
}

