/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.core.mapping.Mapping;
import org.nkjmlab.sorm4j.core.util.Try;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;

public final class ColumnsMapping<T>
extends Mapping<T> {
    private final Constructor<T> constructor;
    private final Map<List<String>, List<Class<?>>> setterParameterTypesMap = new ConcurrentHashMap();

    ColumnsMapping(Class<T> objectClass, ResultSetConverter defaultResultSetConverter, ColumnFieldMapper columnFieldMapper) {
        super(defaultResultSetConverter, objectClass, columnFieldMapper);
        this.constructor = Try.createSupplierWithThrow(() -> objectClass.getDeclaredConstructor(new Class[0]), e -> new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", (Throwable)e)).get();
        this.constructor.setAccessible(true);
    }

    static <T> ColumnsMapping<T> createMapping(Class<T> objectClass, ResultSetConverter converter, ColumnFieldMapper nameGuesser) {
        return new ColumnsMapping<T>(objectClass, converter, nameGuesser);
    }

    String getFormattedString() {
        return "[" + ColumnsMapping.class.getSimpleName() + "] Columns are mappted to a class" + System.lineSeparator() + super.getColumnToAccessorString();
    }

    T loadPojo(ResultSet resultSet) throws SQLException {
        List<String> columns = ColumnsMapping.createColumns(resultSet);
        return this.createPojo(columns, this.convertToObjects(resultSet, this.getSetterParameterTypes(columns)));
    }

    final List<T> loadPojoList(ResultSet resultSet) throws SQLException {
        List<String> columns = ColumnsMapping.createColumns(resultSet);
        List<Class<?>> setterParamTypes = this.getSetterParameterTypes(columns);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.createPojo(columns, this.convertToObjects(resultSet, setterParamTypes)));
        }
        return ret;
    }

    private final List<Object> convertToObjects(ResultSet resultSet, List<Class<?>> setterParameterTypes) throws SQLException {
        ArrayList<Object> values = new ArrayList<Object>(setterParameterTypes.size());
        for (int i = 1; i <= setterParameterTypes.size(); ++i) {
            Class<?> type = setterParameterTypes.get(i - 1);
            values.add(this.resultSetConverter.getValueBySetterParameterType(resultSet, i, type));
        }
        return values;
    }

    private T createPojo(List<String> columns, List<Object> values) {
        T ret = this.createNewPojoInstance();
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i);
            Object value = values.get(i);
            this.setValue(ret, columnName, value);
        }
        return ret;
    }

    private final T createNewPojoInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", e);
        }
    }

    private static List<String> createColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnName(i));
        }
        return columns;
    }

    private List<Class<?>> getSetterParameterTypes(List<String> columns) {
        return this.setterParameterTypesMap.computeIfAbsent(columns, k -> columns.stream().map(c -> this.columnToAccessorMap.get((String)c).getSetterParameterType()).collect(Collectors.toList()));
    }
}

