/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.core.mapping.multirow;

import java.util.function.Function;
import org.nkjmlab.sorm4j.Configurator;
import org.nkjmlab.sorm4j.core.mapping.TableMapping;
import org.nkjmlab.sorm4j.core.mapping.multirow.BatchOfMultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.core.mapping.multirow.MultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.core.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.core.mapping.multirow.SimpleBatchProcessor;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;

public final class MultiRowProcessorGeneratorFactory {
    private final Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory;

    private MultiRowProcessorGeneratorFactory(Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory) {
        this.multiRowProcessorFactory = multiRowProcessorFactory;
    }

    public Function<TableMapping<?>, MultiRowProcessor<?>> getMultiRowProcessorFunction() {
        return this.multiRowProcessorFactory;
    }

    public static MultiRowProcessorGeneratorFactory createMultiRowProcessorFactory(SqlParameterSetter sqlParameterSetter, Configurator.MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        switch (multiRowProcessorType) {
            case SIMPLE_BATCH: {
                return new MultiRowProcessorGeneratorFactory(t -> new SimpleBatchProcessor(sqlParameterSetter, t, batchSize));
            }
            case MULTI_ROW: {
                return new MultiRowProcessorGeneratorFactory(t -> new MultiRowInOneStatementProcessor(sqlParameterSetter, t, batchSize, multiRowSize));
            }
            case MULTI_ROW_AND_BATCH: {
                return new MultiRowProcessorGeneratorFactory(t -> new BatchOfMultiRowInOneStatementProcessor(sqlParameterSetter, t, batchSize, multiRowSize, batchSizeWithMultiRow));
            }
        }
        return null;
    }
}

