package org.nkjmlab.sorm4j.extension;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * A mapper from column to field name.
 *
 * @author nkjm
 *
 */
public interface ColumnFieldMapper {

  /**
   *
   * Retrieves a list of auto-generated columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   * Gets column names of the given table name of the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<Column> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException;

  /**
   *
   * Retrieves a list of primary keys columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */

  List<Column> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException;


  /**
   * Gets field name corresponding to the column name.
   *
   * @param column column name
   * @param fieldNames fieldNames exists in mapped object.
   * @return
   */
  Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames);

  /**
   * Gets column name candidates based the field names.
   *
   * @param fieldNames
   * @return
   */
  List<Column> getColumnNameCandidates(List<FieldName> fieldNames);

  /**
   * Creates accessors map.
   *
   * @param columns
   * @param objectClass
   * @return
   */
  Map<String, Accessor> createAccessors(List<Column> columns, Class<?> objectClass);

  /**
   * Creates accessors map.
   *
   * @param objectClass
   * @return
   */
  Map<String, Accessor> createAccessors(Class<?> objectClass);



}
