/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.OrmColum;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmIgnore;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.Column;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.FieldName;
import org.nkjmlab.sorm4j.internal.util.LoggerFactory;
import org.nkjmlab.sorm4j.internal.util.SqlTypeUtils;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.slf4j.Logger;

public class DefaultColumnFieldMapper
implements ColumnFieldMapper {
    private static final Logger log = LoggerFactory.getLogger();

    private static Map<FieldName, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.isNull(m.getAnnotation(ignoreAnn)) && !Modifier.isStatic(m.getModifiers()) && m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> new FieldName(m.getName().substring(prefix.length(), prefix.length() + 1).toLowerCase() + m.getName().substring(prefix.length() + 1)), m -> m));
    }

    private static Map<FieldName, Field> getAllFields(Class<?> objectClass) {
        Class<OrmIgnore> ignoreAnn = OrmIgnore.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.isNull(f.getAnnotation(ignoreAnn)) && !Modifier.isStatic(f.getModifiers())).collect(Collectors.toMap(f -> new FieldName((Field)f), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<FieldName, Method> getAllGetters(Class<?> objectClass) {
        Map<FieldName, Method> getters = DefaultColumnFieldMapper.extractedMethodStartWith(objectClass, "get");
        return getters;
    }

    private static Map<FieldName, Method> getAllSetters(Class<?> objectClass) {
        Map<FieldName, Method> setters = DefaultColumnFieldMapper.extractedMethodStartWith(objectClass, "set");
        return setters;
    }

    private static Map<Column, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Map<Column, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColum> ann = OrmColum.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> new Column(((OrmColum)f.getAnnotation(ann)).value()), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<Column, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Method isValidGetter(Method getter) {
        if (getter == null) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            log.warn("Getter [{}] should not have parameter but has {} params.", (Object)getter, (Object)getter.getParameterCount());
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            log.warn("Getter [{}] must have return a parameter.", (Object)getter);
        }
        return getter;
    }

    private static Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            log.warn("Setter [{}] should have a single parameter but has {} params.", (Object)setter, (Object)setter.getParameterCount());
            return null;
        }
        return setter;
    }

    @Override
    public Map<String, Accessor> createAccessors(Class<?> objectClass) {
        return this.createAccessors(this.guessColumnNames(objectClass), objectClass);
    }

    @Override
    public Map<String, Accessor> createAccessors(List<Column> columns, Class<?> objectClass) {
        Map<FieldName, Field> fields = DefaultColumnFieldMapper.getAllFields(objectClass);
        Map<FieldName, Method> getters = DefaultColumnFieldMapper.getAllGetters(objectClass);
        Map<FieldName, Method> setters = DefaultColumnFieldMapper.getAllSetters(objectClass);
        Map<Column, Field> annotatedFields = DefaultColumnFieldMapper.getAnnotatedFieldsMap(objectClass);
        Map<Column, Method> annotatedGetters = DefaultColumnFieldMapper.getAnnotatedGettersMap(objectClass);
        Map<Column, Method> annotatedSetters = DefaultColumnFieldMapper.getAnnotatatedSettersMap(objectClass);
        ArrayList<FieldName> fieldsList = new ArrayList<FieldName>(fields.keySet());
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (Column column : columns) {
            Field f = annotatedFields.get(column);
            Method g = DefaultColumnFieldMapper.isValidGetter(annotatedGetters.get(column));
            Method s = DefaultColumnFieldMapper.isValidSetter(annotatedSetters.get(column));
            Optional<FieldName> op = this.getFieldNameByColumnName(column, fieldsList);
            if (op.isPresent()) {
                FieldName fieldName = op.get();
                f = f != null ? f : fields.get(fieldName);
                g = g != null ? g : DefaultColumnFieldMapper.isValidGetter(getters.get(fieldName));
                Method method = s = s != null ? g : DefaultColumnFieldMapper.isValidSetter(setters.get(fieldName));
            }
            if (f == null && (g == null || s == null)) {
                log.debug("Skip matching with Column [{}] to field because could not found corresponding field.", (Object)column);
                continue;
            }
            ret.put(column.getName(), new Accessor(column, f, g, s));
        }
        return ret;
    }

    @Override
    public List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<Column> columnsList = new ArrayList<Column>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                if (!isAutoIncrement.equals("YES")) continue;
                columnsList.add(new Column(columnName));
            }
            ArrayList<Column> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<Column> getColumnNameCandidates(List<FieldName> fieldNames) {
        return fieldNames.stream().flatMap(fieldName -> this.guessColumnNameCandidates((FieldName)fieldName).stream()).collect(Collectors.toList());
    }

    @Override
    public List<Column> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<Column> columnsList = new ArrayList<Column>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                int dataType = resultSet.getInt(5);
                final class ColumnOnTable
                extends Column {
                    private int dataType;

                    public ColumnOnTable(String name, int dataType) {
                        super(name);
                        this.dataType = dataType;
                    }

                    @Override
                    public String toString() {
                        return this.getName() + "(" + SqlTypeUtils.sqlTypeToString(this.dataType) + ")";
                    }
                }
                columnsList.add(new ColumnOnTable(columnName, dataType));
            }
            ArrayList<Column> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames) {
        for (FieldName fieldName : fieldNames) {
            if (!StringUtils.containsIgnoreCase(this.guessColumnNameCandidates(fieldName).stream().map(s -> s.toString()).collect(Collectors.toList()), column.getName())) continue;
            return Optional.of(fieldName);
        }
        return Optional.empty();
    }

    @Override
    public List<Column> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<Column> primaryKeysList = new ArrayList<Column>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(new Column(columnName));
            }
            ArrayList<Column> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    protected String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }

    protected List<Column> guessColumnNameCandidates(FieldName fieldName) {
        return List.of(new Column(StringUtils.toUpperSnakeCase(fieldName.getName())), new Column(StringUtils.toUpperCase(fieldName.getName())));
    }

    List<Column> guessColumnNames(Class<?> objectClass) {
        HashSet<FieldName> names = new HashSet<FieldName>();
        names.addAll(DefaultColumnFieldMapper.getAllFields(objectClass).keySet());
        names.addAll(DefaultColumnFieldMapper.getAllGetters(objectClass).keySet());
        names.addAll(DefaultColumnFieldMapper.getAllSetters(objectClass).keySet());
        List<Column> columns = this.getColumnNameCandidates(new ArrayList<FieldName>(names));
        columns.addAll(DefaultColumnFieldMapper.getAnnotatedFieldsMap(objectClass).keySet());
        columns.addAll(DefaultColumnFieldMapper.getAnnotatedGettersMap(objectClass).keySet());
        columns.addAll(DefaultColumnFieldMapper.getAnnotatatedSettersMap(objectClass).keySet());
        return columns;
    }
}

