/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.ConsumerHandler;
import org.nkjmlab.sorm4j.FunctionHandler;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmTransaction;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.SormFactory;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.TypedOrmTransaction;
import org.nkjmlab.sorm4j.internal.mapping.ConfigStore;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.TypedOrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class SormImpl
implements Sorm {
    private final DataSource dataSource;
    private final ConfigStore configStore;

    public SormImpl(DataSource connectionSource, ConfigStore configs) {
        this.configStore = configs;
        this.dataSource = connectionSource;
    }

    @Override
    public OrmTransaction openTransaction() {
        return new OrmTransactionImpl(this.getJdbcConnection(), this.configStore);
    }

    @Override
    public <T> TypedOrmTransaction<T> openTransaction(Class<T> objectClass) {
        return new TypedOrmTransactionImpl<T>(objectClass, new OrmTransactionImpl(this.getJdbcConnection(), this.configStore));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R apply(Class<T> objectClass, FunctionHandler<TypedOrmConnection<T>, R> handler) {
        try (TypedOrmConnection<T> conn = this.openConnection(objectClass);){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R apply(FunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection conn = this.openConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R applyTransactionHandler(Class<T> objectClass, FunctionHandler<TypedOrmTransaction<T>, R> handler) {
        try (TypedOrmTransaction<T> transaction = this.openTransaction(objectClass);){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R applyTransactionHandler(FunctionHandler<OrmTransaction, R> handler) {
        try (OrmTransaction transaction = this.openTransaction();){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R applyJdbcConnectionHandler(FunctionHandler<Connection, R> handler) {
        try (Connection conn = this.getJdbcConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public String getConfigName() {
        return this.configStore.getConfigName();
    }

    @Override
    public String getConfigString() {
        return this.configStore.toString();
    }

    @Override
    public OrmConnection openConnection() {
        return new OrmConnectionImpl(this.getJdbcConnection(), this.configStore);
    }

    @Override
    public <T> TypedOrmConnection<T> openConnection(Class<T> objectClass) {
        return new TypedOrmConnectionImpl<T>(objectClass, new OrmConnectionImpl(this.getJdbcConnection(), this.configStore));
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getJdbcConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> void accept(Class<T> objectClass, ConsumerHandler<TypedOrmConnection<T>> handler) {
        try (TypedOrmConnection<T> conn = this.openConnection(objectClass);){
            try {
                handler.accept(conn);
            }
            catch (Exception e) {
                throw Try.rethrow(e);
            }
        }
    }

    @Override
    public void accept(ConsumerHandler<OrmConnection> handler) {
        try (OrmConnection conn = this.openConnection();){
            handler.accept(conn);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public <T> void acceptTransactionHandler(Class<T> objectClass, ConsumerHandler<TypedOrmTransaction<T>> handler) {
        try (TypedOrmTransaction<T> transaction = this.openTransaction(objectClass);){
            handler.accept(transaction);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void acceptTransactionHandler(ConsumerHandler<OrmTransaction> handler) {
        try (OrmTransaction conn = this.openTransaction();){
            handler.accept(conn);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void acceptJdbcConnectionHandler(ConsumerHandler<Connection> handler) {
        try (Connection conn = this.getJdbcConnection();){
            handler.accept(conn);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public String toString() {
        return "Sorm [dataSource=" + this.dataSource + ", configStore=" + this.configStore + "]";
    }

    @Override
    public Sorm createWith(String configName) {
        return SormFactory.create(this.dataSource, configName);
    }

    @Override
    public Map<String, String> getTableMappingStatusMap() {
        return this.configStore.getTableMappings().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((TableMapping)e.getValue()).getFormattedString()));
    }

    public static class TypedOrmTransactionImpl<T>
    extends TypedOrmConnectionImpl<T>
    implements TypedOrmTransaction<T> {
        public TypedOrmTransactionImpl(Class<T> objectClass, OrmTransactionImpl ormTransaction) {
            super(objectClass, ormTransaction);
            this.begin(ormTransaction.getTransactionIsolationLevel());
        }

        @Override
        public void close() {
            this.rollback();
            super.close();
        }

        @Override
        public <S> TypedOrmTransaction<S> type(Class<S> objectClass) {
            return new TypedOrmTransactionImpl<S>(objectClass, (OrmTransactionImpl)this.ormConnection);
        }

        @Override
        public OrmTransaction untype() {
            return (OrmTransactionImpl)this.ormConnection;
        }
    }

    public static final class OrmTransactionImpl
    extends OrmConnectionImpl
    implements OrmTransaction {
        public OrmTransactionImpl(Connection connection, ConfigStore options) {
            super(connection, options);
            this.begin(options.getTransactionIsolationLevel());
        }

        @Override
        public void close() {
            this.rollback();
            super.close();
        }

        @Override
        public <T> TypedOrmTransaction<T> type(Class<T> objectClass) {
            return new TypedOrmTransactionImpl<T>(objectClass, this);
        }
    }
}

