/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TableMappingSql {
    private static final Map<String, String> multiRowSqlMap = new ConcurrentHashMap<String, String>();
    private final String tableName;
    private final List<String> columns;
    private final List<String> primaryKeys;
    private final String[] autoGeneratedColumnsArray;
    private final List<String> notAutoGeneratedColumns;
    private final List<String> columnsForUpdate;
    private final boolean hasPrimaryKey;
    private final boolean hasAutoGeneratedColumns;
    private final String insertOrMergePlaceholders;
    private final String selectByPrimaryKeySql;
    private final String selectAllSql;
    private final String insertSql;
    private final String updateSql;
    private final String deleteSql;
    private final String deleteAllSql;
    private final String mergeSql;
    private final String insertSqlPrefix;
    private final String mergeSqlPrefix;

    public TableMappingSql(String tableName, List<String> columns, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        this.tableName = tableName;
        this.columns = columns;
        this.primaryKeys = primaryKeys;
        this.notAutoGeneratedColumns = columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList());
        this.hasPrimaryKey = primaryKeys.size() != 0;
        this.hasAutoGeneratedColumns = autoGeneratedColumns.size() != 0;
        this.autoGeneratedColumnsArray = (String[])autoGeneratedColumns.toArray(String[]::new);
        this.insertSqlPrefix = "insert into " + tableName + " (" + this.toColumList(this.notAutoGeneratedColumns) + ") values";
        this.mergeSqlPrefix = "merge into " + tableName + " (" + this.toColumList(this.notAutoGeneratedColumns) + ") values";
        this.insertOrMergePlaceholders = " (" + this.generatePlaceholders(this.notAutoGeneratedColumns.size()) + ") ";
        this.insertSql = this.insertSqlPrefix + this.insertOrMergePlaceholders;
        this.mergeSql = this.mergeSqlPrefix + this.insertOrMergePlaceholders;
        this.selectAllSql = "select " + this.toColumList(columns) + " from " + tableName;
        this.selectByPrimaryKeySql = this.selectAllSql + " " + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        List<String> notPrimaryKeys = columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList());
        this.columnsForUpdate = Stream.concat(notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList());
        this.updateSql = "update " + tableName + this.createUpdateSetClause(notPrimaryKeys) + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        this.deleteSql = "delete from " + tableName + this.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        this.deleteAllSql = "delete from " + tableName;
    }

    private String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)",", notPrimaryKeys.stream().map(npk -> npk + "=?").collect(Collectors.toList()));
    }

    private String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> pk + "=?").collect(Collectors.toList()));
    }

    private String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }

    public String[] getAutoGeneratedColumnsArray() {
        return this.autoGeneratedColumnsArray;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getColumnsForUpdate() {
        return this.columnsForUpdate;
    }

    public String getDeleteAllSql() {
        return this.deleteAllSql;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public String getMergeSql() {
        return this.mergeSql;
    }

    public String getMultirowInsertSql(int num) {
        return this.getPlaceholders(this.insertSqlPrefix, num);
    }

    public String getMultirowMergeSql(int num) {
        return this.getPlaceholders(this.mergeSqlPrefix, num);
    }

    public List<String> getNotAutoGeneratedColumns() {
        return this.notAutoGeneratedColumns;
    }

    private String getPlaceholders(String sqlPrefix, int num) {
        return multiRowSqlMap.computeIfAbsent(sqlPrefix + num, n -> sqlPrefix + String.join((CharSequence)",", Stream.generate(() -> this.insertOrMergePlaceholders).limit(num).collect(Collectors.toList())));
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String getSelectAllSql() {
        return this.selectAllSql;
    }

    public String getSelectByPrimaryKeySql() {
        return this.selectByPrimaryKeySql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUpdateSql() {
        return this.updateSql;
    }

    public boolean hasAutoGeneratedColumns() {
        return this.hasAutoGeneratedColumns;
    }

    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    private String toColumList(List<String> columns) {
        return String.join((CharSequence)",", columns);
    }
}

