/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.TypedOrmMapperImpl;
import org.nkjmlab.sorm4j.internal.sql.NamedParameterQueryImpl;
import org.nkjmlab.sorm4j.internal.sql.OrderedParameterQueryImpl;
import org.nkjmlab.sorm4j.internal.sql.QueryTypedOrmExecutor;
import org.nkjmlab.sorm4j.internal.sql.SelectQueryImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.NamedParameterQuery;
import org.nkjmlab.sorm4j.sql.NamedParameterRequest;
import org.nkjmlab.sorm4j.sql.OrderedParameterQuery;
import org.nkjmlab.sorm4j.sql.OrderedParameterRequest;
import org.nkjmlab.sorm4j.sql.SelectQuery;

public class TypedOrmConnectionImpl<T>
extends TypedOrmMapperImpl<T>
implements TypedOrmConnection<T> {
    public TypedOrmConnectionImpl(Class<T> objectClass, OrmConnectionImpl ormMapper) {
        super(objectClass, ormMapper);
    }

    @Override
    public String getTableName() {
        return this.ormConnection.getTableName(this.objectClass);
    }

    @Override
    public void close() {
        Try.runOrThrow(() -> {
            if (this.getJdbcConnection().isClosed()) {
                return;
            }
            this.getJdbcConnection().close();
        }, Try::rethrow);
    }

    @Override
    public void commit() {
        Try.runOrThrow(() -> this.getJdbcConnection().commit(), Try::rethrow);
    }

    @Override
    public void rollback() {
        Try.runOrThrow(() -> this.getJdbcConnection().rollback(), Try::rethrow);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        Try.runOrThrow(() -> this.getJdbcConnection().setAutoCommit(autoCommit), Try::rethrow);
    }

    @Override
    public void begin(int transactionIsolationLevel) {
        this.setAutoCommit(false);
        this.setTransactionIsolation(transactionIsolationLevel);
    }

    @Override
    public void begin() {
        this.begin(this.ormConnection.getTransactionIsolationLevel());
    }

    private void setTransactionIsolation(int level) {
        Try.runOrThrow(() -> this.getJdbcConnection().setTransactionIsolation(level), Try::rethrow);
    }

    @Override
    public SelectQuery<T> createSelectQuery() {
        SelectQueryImpl ret = new SelectQueryImpl(new QueryTypedOrmExecutor(this));
        ret.from(this.getTableName());
        return ret;
    }

    @Override
    public NamedParameterQuery<T> createNamedParameterQuery(String sql) {
        return NamedParameterQueryImpl.createFrom(new QueryTypedOrmExecutor(this), sql);
    }

    @Override
    public OrderedParameterQuery<T> createOrderedParameterQuery(String sql) {
        return OrderedParameterQueryImpl.createFrom(new QueryTypedOrmExecutor(this), sql);
    }

    @Override
    public <S> TypedOrmConnection<S> type(Class<S> objectClass) {
        return new TypedOrmConnectionImpl<S>(objectClass, this.ormConnection);
    }

    @Override
    public OrmConnection untype() {
        return this.ormConnection;
    }

    public <S> S mapRow(Class<S> objectClass, ResultSet resultSet) {
        return (S)this.ormConnection.mapRow((Class)objectClass, resultSet);
    }

    @Override
    public Map<String, Object> mapRow(ResultSet resultSet) {
        return this.ormConnection.mapRow(resultSet);
    }

    public <S> List<S> mapRows(Class<S> objectClass, ResultSet resultSet) {
        return this.ormConnection.mapRows(objectClass, resultSet);
    }

    @Override
    public List<Map<String, Object>> mapRows(ResultSet resultSet) {
        return this.ormConnection.mapRows(resultSet);
    }

    @Override
    public NamedParameterRequest createNamedParameterRequest(String sql) {
        return NamedParameterRequest.from(this, sql);
    }

    @Override
    public OrderedParameterRequest createOrderedParameterRequest(String sql) {
        return OrderedParameterRequest.from(this, sql);
    }
}

