/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmTable;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public class DefaultTableNameMapper
implements TableNameMapper {
    @Override
    public TableName getTableName(String tableName, DatabaseMetaData metaData) throws SQLException {
        List<String> candidates = List.of(tableName);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(StringUtils.format("[{}] does not match any existing table in the database. Table Name candidates are {}", tableName, candidates)));
    }

    @Override
    public TableName getTableName(Class<?> objectClass, DatabaseMetaData metaData) throws SQLException {
        List<String> candidates = this.guessTableNameCandidates(objectClass);
        return this.convertToExactTableName(metaData, candidates).orElseThrow(() -> new SormException(StringUtils.format("[{}] does not match any existing table in the database. Use [{}] annotation correctly. Table Name candidates are {}", objectClass.getName(), OrmTable.class.getName(), candidates)));
    }

    protected List<String> guessTableNameCandidates(Class<?> objectClass) {
        OrmTable tableAnnotation = objectClass.getAnnotation(OrmTable.class);
        if (tableAnnotation != null && !tableAnnotation.value().equals("")) {
            return Arrays.asList(tableAnnotation.value());
        }
        String className = objectClass.getSimpleName();
        return StringUtils.addPluralSuffix(List.of(StringUtils.toCanonical(className)));
    }

    protected Optional<TableName> convertToExactTableName(DatabaseMetaData metaData, List<String> tableNameCandidates) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                String tableNameOnDb = resultSet.getString(3);
                if (!this.isMatch(tableNameCandidates, tableNameOnDb)) continue;
                Optional<TableName> optional = Optional.of(new TableName(tableNameOnDb));
                return optional;
            }
            Optional<TableName> optional = Optional.empty();
            return optional;
        }
    }

    protected boolean isMatch(List<String> candidates, String exactTableName) {
        return StringUtils.containsAsCanonical(candidates, exactTableName);
    }
}

