/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.mapping.Mapping;
import org.nkjmlab.sorm4j.internal.util.Try;

public final class ColumnsMapping<T>
extends Mapping<T> {
    private final Constructor<T> constructor;
    private final Map<List<String>, List<Class<?>>> setterParameterTypesMap = new ConcurrentHashMap();

    public ColumnsMapping(Class<T> objectClass, ResultSetConverter resultSetConverter, ColumnToAccessorMap columnToAccessorMap, Constructor<T> constructor) {
        super(resultSetConverter, objectClass, columnToAccessorMap);
        this.constructor = constructor;
    }

    private T createPojo(List<String> columns, List<Class<?>> setterParameterTypes, ResultSet resultSet) {
        try {
            T ret = this.constructor.newInstance(new Object[0]);
            for (int i = 1; i <= columns.size(); ++i) {
                String columnName = columns.get(i - 1);
                Class<?> setterParameterType = setterParameterTypes.get(i - 1);
                Object value = this.resultSetConverter.getValueBySetterParameterType(resultSet, i, setterParameterType);
                this.setValue(ret, columnName, value);
            }
            return ret;
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SormException("Container class for object relation mapping must have the public default constructor (with no arguments).", e);
        }
    }

    String getFormattedString() {
        return "[" + ColumnsMapping.class.getSimpleName() + "] Columns are mappted to a class" + System.lineSeparator() + super.getColumnToAccessorString();
    }

    private List<Class<?>> getSetterParameterTypes(List<String> columns) {
        return this.setterParameterTypesMap.computeIfAbsent(columns, k -> columns.stream().map(columnName -> this.columnToAccessorMap.get((String)columnName).getSetterParameterType()).collect(Collectors.toList()));
    }

    T loadPojo(ResultSet resultSet) throws SQLException {
        List<String> columns = ColumnsMapping.createColumns(resultSet);
        List<Class<?>> setterParameterTypes = this.getSetterParameterTypes(columns);
        return this.createPojo(columns, setterParameterTypes, resultSet);
    }

    List<T> loadPojoList(ResultSet resultSet) throws SQLException {
        List<String> columns = ColumnsMapping.createColumns(resultSet);
        List<Class<?>> setterParameterTypes = this.getSetterParameterTypes(columns);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.createPojo(columns, setterParameterTypes, resultSet));
        }
        return ret;
    }

    private static List<String> createColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnName(i));
        }
        return columns;
    }
}

