/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.SqlStatement;

public class NamedParameterSqlImpl
implements NamedParameterSql {
    private static final String DEFAULT_PREFIX = ":";
    private static final String DEFAULT_SUFFIX = "";
    private final String sql;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final String prefix;
    private final String suffix;

    public NamedParameterSqlImpl(String sql, String prefix, String suffix) {
        this.sql = sql;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public NamedParameterSqlImpl(String sql) {
        this(sql, DEFAULT_PREFIX, DEFAULT_SUFFIX);
    }

    @Override
    public NamedParameterSql bindAll(Map<String, Object> namedParams) {
        namedParams.entrySet().stream().forEach(e -> this.bind((String)e.getKey(), e.getValue()));
        return this;
    }

    @Override
    public NamedParameterSql bind(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    @Override
    public SqlStatement toSqlStatement() {
        TreeMap<Integer, Object> orderdParams = new TreeMap<Integer, Object>();
        String resultSql = this.sql;
        for (String parameterName : this.parameters.keySet().stream().sorted(Comparator.comparing(String::length).reversed()).collect(Collectors.toList())) {
            String namedPlaceholder = this.prefix + parameterName + this.suffix;
            int pos = resultSql.indexOf(namedPlaceholder);
            if (pos == -1) continue;
            orderdParams.put(pos, this.parameters.get(parameterName));
            resultSql = resultSql.replaceAll(namedPlaceholder, "?");
        }
        return SqlStatement.from(resultSql, orderdParams.values().toArray());
    }
}

