/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.extension.Configurator;
import org.nkjmlab.sorm4j.internal.mapping.ConfigStore;
import org.nkjmlab.sorm4j.internal.mapping.ConfiguratorImpl;
import org.nkjmlab.sorm4j.internal.mapping.DriverManagerDataSource;
import org.nkjmlab.sorm4j.internal.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.mapping.SormImpl;
import org.nkjmlab.sorm4j.internal.mapping.TypedOrmConnectionImpl;

public final class SormFactory {
    public static final String DEFAULT_CONFIG_NAME = "DEFAULT_CONFIG";

    private static void configure(ConfiguratorImpl configurator, Consumer<Configurator> configuratorConsumer) {
        configuratorConsumer.accept(configurator);
        ConfigStore.refreshAndRegister(configurator.build());
    }

    public static Sorm create(DataSource dataSource) {
        return SormFactory.create(dataSource, DEFAULT_CONFIG_NAME);
    }

    public static Sorm create(DataSource dataSource, String configName) {
        return new SormImpl(dataSource, ConfigStore.get(configName));
    }

    public static Sorm create(String jdbcUrl, String user, String password) {
        return SormFactory.create(jdbcUrl, user, password, DEFAULT_CONFIG_NAME);
    }

    public static Sorm create(String jdbcUrl, String username, String password, String configName) {
        return SormFactory.create(SormFactory.createDriverManagerConnectionSource(jdbcUrl, username, password), configName);
    }

    private static DataSource createDriverManagerConnectionSource(String jdbcUrl, String username, String password) {
        return new DriverManagerDataSource(jdbcUrl, username, password);
    }

    public static String getConfigString(String configName) {
        return ConfigStore.get(configName).toString();
    }

    public static void registerConfig(String configName, Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(configName), configuratorConsumer);
    }

    public static void registerModifiedConfig(String srcConfigName, String newConfigName, Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(newConfigName, ConfigStore.get(srcConfigName)), configuratorConsumer);
    }

    public static void resetDefaultConfig() {
        ConfigStore.refreshAndRegister(ConfigStore.INITIAL_DEFAULT_CONFIG_STORE);
    }

    public static OrmConnection toOrmConnection(Connection connection) {
        return SormFactory.toOrmConnection(connection, ConfigStore.getDefaultConfigStore());
    }

    public static <T> TypedOrmConnection<T> toOrmConnection(Connection conn, Class<T> objectClass) {
        return SormFactory.toOrmConnection(conn, objectClass, ConfigStore.getDefaultConfigStore());
    }

    private static <T> TypedOrmConnection<T> toOrmConnection(Connection connection, Class<T> objectClass, ConfigStore configStore) {
        return new TypedOrmConnectionImpl<T>(objectClass, new OrmConnectionImpl(connection, configStore));
    }

    public static <T> TypedOrmConnection<T> toOrmConnection(Connection conn, Class<T> objectClass, String configName) {
        return SormFactory.toOrmConnection(conn, objectClass, ConfigStore.get(configName));
    }

    private static OrmConnection toOrmConnection(Connection connection, ConfigStore configStore) {
        return new OrmConnectionImpl(connection, configStore);
    }

    public static OrmConnection toOrmConnection(Connection connection, String configName) {
        return SormFactory.toOrmConnection(connection, ConfigStore.get(configName));
    }

    public static void updateDefaultConfig(Consumer<Configurator> configuratorConsumer) {
        SormFactory.configure(new ConfiguratorImpl(DEFAULT_CONFIG_NAME), configuratorConsumer);
    }

    private SormFactory() {
    }
}

