/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.nkjmlab.sorm4j.extension.AbstractResultSetConverter;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.internal.util.Try;

public class DefaultResultSetConverter
extends AbstractResultSetConverter {
    private static final Set<Class<?>> nativeSqlTypes = Set.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, byte[].class, Byte[].class, char[].class, Character[].class, String.class, BigDecimal.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, LocalDate.class, LocalTime.class, LocalDateTime.class, InputStream.class, Reader.class, Clob.class, Blob.class, UUID.class, OffsetTime.class, OffsetDateTime.class, Inet4Address.class, URL.class, Inet6Address.class, int[].class, Integer[].class, String[].class, Object.class);

    @Override
    public boolean isEnableToConvertNativeObject(SormOptions options, Class<?> objectClass) {
        return nativeSqlTypes.contains(objectClass);
    }

    @Override
    public Object getColumnValue(SormOptions options, ResultSet resultSet, int column, int columnType, Class<?> setterType) throws SQLException {
        String name;
        if (setterType.isEnum()) {
            String v = resultSet.getString(column);
            return Arrays.stream(setterType.getEnumConstants()).filter(o -> o.toString().equals(v)).findAny().orElse(null);
        }
        if (setterType.isArray()) {
            String name2;
            switch (name2 = setterType.getComponentType().getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    return resultSet.getBytes(column);
                }
                case "char": 
                case "java.lang.Character": {
                    String str = resultSet.getString(column);
                    return str == null ? null : str.toCharArray();
                }
            }
            return resultSet.getObject(column);
        }
        switch (name = setterType.getName()) {
            case "boolean": {
                return resultSet.getBoolean(column);
            }
            case "java.lang.Boolean": {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case "byte": {
                return resultSet.getByte(column);
            }
            case "java.lang.Byte": {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case "short": {
                return resultSet.getShort(column);
            }
            case "java.lang.Short": {
                short ret = resultSet.getShort(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case "int": {
                return resultSet.getInt(column);
            }
            case "java.lang.Integer": {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case "long": {
                return resultSet.getLong(column);
            }
            case "java.lang.Long": {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(column));
            }
            case "java.lang.Float": {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case "double": {
                return resultSet.getDouble(column);
            }
            case "java.lang.Double": {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(column);
            }
            case "java.lang.String": {
                return resultSet.getString(column);
            }
            case "java.lang.Character": 
            case "char": {
                String str = resultSet.getString(column);
                return str == null || str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            case "java.sql.Date": {
                return resultSet.getDate(column);
            }
            case "java.sql.Time": {
                return resultSet.getTime(column);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(column);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(column);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(column);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(column);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(column);
            }
            case "java.time.LocalTime": {
                return Optional.ofNullable(resultSet.getTime(column)).map(t -> t.toLocalTime()).orElse(null);
            }
            case "java.time.LocalDate": {
                return Optional.ofNullable(resultSet.getDate(column)).map(t -> t.toLocalDate()).orElse(null);
            }
            case "java.time.LocalDateTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime()).orElse(null);
            }
            case "java.util.Date": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> new java.util.Date(t.getTime())).orElse(null);
            }
            case "java.util.UUID": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> UUID.fromString(s)).orElse(null);
            }
            case "java.time.OffsetTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime()).orElse(null);
            }
            case "java.time.OffsetDateTime": {
                return Optional.ofNullable(resultSet.getTimestamp(column)).map(t -> t.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime()).orElse(null);
            }
            case "java.net.URL": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrNull(() -> new URL((String)s))).orElse(null);
            }
            case "java.net.Inet4Address": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrNull(() -> Inet4Address.getByName(s))).orElse(null);
            }
            case "java.net.Inet6Address": {
                return Optional.ofNullable(resultSet.getString(column)).map(s -> Try.getOrNull(() -> Inet6Address.getByName(s))).orElse(null);
            }
            case "java.lang.Object": {
                return resultSet.getObject(column);
            }
        }
        return resultSet.getObject(column);
    }

    @Override
    protected Object getColumnValueBySqlType(ResultSet resultSet, int column, int sqlType) throws SQLException {
        switch (sqlType) {
            case 2003: {
                return resultSet.getArray(column);
            }
            case -5: {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return resultSet.getBytes(column);
            }
            case -7: 
            case 16: {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return resultSet.getString(column);
            }
            case 70: {
                return resultSet.getBinaryStream(column);
            }
            case 91: {
                return resultSet.getDate(column);
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(column);
            }
            case 7: 
            case 8: {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case 6: {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case 4: {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case 0: {
                return null;
            }
            case 2006: {
                return resultSet.getRef(column);
            }
            case -8: {
                return resultSet.getRowId(column);
            }
            case 5: {
                short ret = (short)resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case 92: {
                return resultSet.getTime(column);
            }
            case 93: {
                return resultSet.getTimestamp(column);
            }
            case -6: {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case 1111: 
            case 2000: {
                return resultSet.getObject(column);
            }
        }
        return resultSet.getObject(column);
    }
}

