/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.internal.util.Try;

public class DefaultSqlParameterSetter
implements SqlParameterSetter {
    @Override
    public void setParameters(SormOptions options, PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        for (int i = 1; i <= parameters.length; ++i) {
            Object parameter = parameters[i - 1];
            if (parameter == null) {
                stmt.setNull(i, 0);
                continue;
            }
            this.setParameter(stmt, i, parameter);
        }
    }

    protected void setParameter(PreparedStatement stmt, int column, Object parameter) throws SQLException {
        Class<?> type = parameter.getClass();
        if (type.isEnum()) {
            stmt.setString(column, parameter.toString());
        } else if (type.isArray()) {
            String name = type.getComponentType().getName();
            this.procArray(name, stmt, column, parameter);
        } else if (List.class.isAssignableFrom(type)) {
            this.procList(stmt, column, (List)parameter);
        } else {
            this.procObject(type, stmt, column, parameter);
        }
    }

    protected void procObject(Class<?> type, PreparedStatement stmt, int column, Object parameter) throws SQLException {
        if (parameter instanceof Clob) {
            stmt.setClob(column, (Clob)parameter);
        } else if (parameter instanceof Blob) {
            stmt.setBlob(column, (Blob)parameter);
        } else if (parameter instanceof Reader) {
            Reader reader = (Reader)parameter;
            stmt.setCharacterStream(column, reader, DefaultSqlParameterSetter.getSize(reader));
        } else if (parameter instanceof InputStream) {
            InputStream inputStream = (InputStream)parameter;
            stmt.setBinaryStream(column, inputStream, DefaultSqlParameterSetter.getSize(inputStream));
        } else {
            String typeName;
            switch (typeName = type.getName()) {
                case "java.lang.Boolean": 
                case "boolean": {
                    stmt.setBoolean(column, (Boolean)parameter);
                    return;
                }
                case "java.lang.Byte": 
                case "byte": {
                    stmt.setByte(column, (Byte)parameter);
                    return;
                }
                case "java.lang.Short": 
                case "short": {
                    stmt.setShort(column, (Short)parameter);
                    return;
                }
                case "java.lang.Integer": 
                case "int": {
                    stmt.setInt(column, (Integer)parameter);
                    return;
                }
                case "java.lang.Long": 
                case "long": {
                    stmt.setLong(column, (Long)parameter);
                    return;
                }
                case "java.lang.Float": 
                case "float": {
                    stmt.setFloat(column, ((Float)parameter).floatValue());
                    return;
                }
                case "java.lang.Double": 
                case "double": {
                    stmt.setDouble(column, (Double)parameter);
                    return;
                }
                case "java.lang.Character": 
                case "char": {
                    stmt.setString(column, parameter == null ? null : "" + (Character)parameter);
                    return;
                }
                case "java.lang.String": {
                    stmt.setString(column, (String)parameter);
                    return;
                }
                case "java.math.BigDecimal": {
                    stmt.setBigDecimal(column, (BigDecimal)parameter);
                    return;
                }
                case "java.sql.Date": {
                    stmt.setDate(column, parameter == null ? null : Date.valueOf(parameter.toString()));
                    return;
                }
                case "java.sql.Time": {
                    stmt.setTime(column, parameter == null ? null : Time.valueOf(parameter.toString()));
                    return;
                }
                case "java.sql.Timestamp": {
                    stmt.setTimestamp(column, (Timestamp)parameter);
                    return;
                }
                case "java.time.LocalTime": {
                    stmt.setTime(column, parameter == null ? null : Time.valueOf((LocalTime)parameter));
                    return;
                }
                case "java.time.LocalDate": {
                    stmt.setDate(column, parameter == null ? null : Date.valueOf((LocalDate)parameter));
                    return;
                }
                case "java.time.LocalDateTime": {
                    stmt.setTimestamp(column, parameter == null ? null : Timestamp.valueOf((LocalDateTime)parameter));
                    return;
                }
                case "java.util.Date": {
                    stmt.setTimestamp(column, parameter == null ? null : new Timestamp(((java.util.Date)parameter).getTime()));
                    return;
                }
                case "java.time.OffsetTime": {
                    stmt.setTime(column, parameter == null ? null : Time.valueOf(((OffsetTime)parameter).toLocalTime()));
                    return;
                }
                case "java.time.OffsetDateTime": {
                    stmt.setTimestamp(column, parameter == null ? null : Timestamp.valueOf(((OffsetDateTime)parameter).toLocalDateTime()));
                    return;
                }
                case "java.net.URL": {
                    stmt.setString(column, parameter == null ? null : ((URL)parameter).toString());
                    return;
                }
            }
            stmt.setObject(column, parameter);
            return;
        }
    }

    private static final int getSize(InputStream inputStream) {
        try {
            int size = 0;
            inputStream.reset();
            while (inputStream.read() != -1) {
                ++size;
            }
            inputStream.reset();
            return size;
        }
        catch (IOException e) {
            throw Try.rethrow(e);
        }
    }

    private static final int getSize(Reader reader) {
        try {
            int size = 0;
            reader.reset();
            while (reader.read() != -1) {
                ++size;
            }
            reader.reset();
            return size;
        }
        catch (IOException e) {
            throw Try.rethrow(e);
        }
    }

    protected void procArray(String className, PreparedStatement stmt, int column, Object parameter) throws SQLException {
        switch (className) {
            case "char": {
                stmt.setString(column, parameter == null ? null : String.valueOf((char[])parameter));
                return;
            }
            case "java.lang.Character": {
                Character[] src = (Character[])parameter;
                char[] dst = new char[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j].charValue();
                }
                stmt.setString(column, String.valueOf(dst));
                return;
            }
            case "byte": {
                stmt.setBytes(column, (byte[])parameter);
                return;
            }
            case "java.lang.Byte": {
                Byte[] src = (Byte[])parameter;
                byte[] dst = new byte[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j];
                }
                stmt.setBytes(column, dst);
                return;
            }
            case "java.lang.String": {
                stmt.setArray(column, stmt.getConnection().createArrayOf("varchar", (Object[])parameter));
                return;
            }
            case "java.lang.Integer": {
                stmt.setArray(column, stmt.getConnection().createArrayOf("int", (Object[])parameter));
                return;
            }
            case "java.lang.Double": 
            case "java.lang.Float": {
                stmt.setArray(column, stmt.getConnection().createArrayOf("float", (Object[])parameter));
                return;
            }
        }
        stmt.setObject(column, parameter);
    }

    private void procList(PreparedStatement stmt, int column, List<?> parameter) throws SQLException {
        if (parameter.size() == 0) {
            throw new SormException("Size of parameter which type is List should be at least one. ");
        }
        this.procArray(parameter.get(0).getClass().getName(), stmt, column, parameter.toArray());
    }
}

