/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.annotation.OrmColumnAliasPrefix;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public final class ColumnToAccessorMap {
    private final Map<String, Accessor> columnToAccessorMap;
    private final Map<String, Accessor> aliasColumnToAccessorMap;
    private final String columnAliasPrefix;

    public ColumnToAccessorMap(Class<?> objectClass, Map<String, Accessor> columnToAccessorMap) {
        this.columnToAccessorMap = columnToAccessorMap.entrySet().stream().collect(Collectors.toMap(e -> StringUtils.toCanonical((String)e.getKey()), e -> (Accessor)e.getValue()));
        this.columnAliasPrefix = Optional.ofNullable(objectClass.getAnnotation(OrmColumnAliasPrefix.class)).map(a -> a.value()).orElse("");
        if (this.columnAliasPrefix.length() == 0) {
            this.aliasColumnToAccessorMap = new HashMap<String, Accessor>();
            return;
        }
        HashMap<String, Accessor> tmp = new HashMap<String, Accessor>();
        for (String key : columnToAccessorMap.keySet()) {
            String aKey = StringUtils.toCanonical(this.columnAliasPrefix + key);
            if (this.columnToAccessorMap.containsKey(aKey)) {
                throw new SormException(StringUtils.format("Modify table alias because table alias [{}] and column [{}] is concatenated and it becomes duplicated column", this.columnAliasPrefix, key));
            }
            tmp.put(aKey, columnToAccessorMap.get(key));
        }
        this.aliasColumnToAccessorMap = tmp;
    }

    public Accessor get(String columnName) {
        String cn = StringUtils.toCanonical(columnName);
        Accessor ret = this.columnToAccessorMap.get(cn);
        return ret != null ? ret : this.aliasColumnToAccessorMap.get(columnName);
    }

    public String toString() {
        String keySetString = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList()).toString();
        return "COLUMNS " + keySetString + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), this.columnToAccessorMap.keySet().stream().map(e -> "  COLUMN " + e + " => " + this.columnToAccessorMap.get(e).getFormattedString()).collect(Collectors.toList())) + System.lineSeparator() + "  " + this.columnToAccessorMap.values() + System.lineSeparator() + "  OrmColumnAliasPrefix=[" + this.columnAliasPrefix + "]";
    }
}

