/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nkjmlab.sorm4j.internal.mapping.TableMappingSql;

public class TableMappingSqlFactory {
    public TableMappingSql create(String tableName, List<String> columns, List<String> primaryKeys, List<String> autoGeneratedColumns) {
        List<String> notAutoGeneratedColumns = columns.stream().filter(col -> !autoGeneratedColumns.contains(col)).collect(Collectors.toList());
        boolean hasPrimaryKey = primaryKeys.size() != 0;
        boolean hasAutoGeneratedColumns = autoGeneratedColumns.size() != 0;
        String insertSqlPrefix = "insert into " + tableName + " (" + TableMappingSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String mergeSqlPrefix = "merge into " + tableName + " (" + TableMappingSqlFactory.toColumList(notAutoGeneratedColumns) + ") values";
        String insertOrMergePlaceholders = " (" + TableMappingSqlFactory.generatePlaceholders(notAutoGeneratedColumns.size()) + ") ";
        String insertSql = insertSqlPrefix + insertOrMergePlaceholders;
        String mergeSql = mergeSqlPrefix + insertOrMergePlaceholders;
        String selectAllSql = "select " + TableMappingSqlFactory.toColumList(columns) + " from " + tableName;
        String selectByPrimaryKeySql = selectAllSql + " " + TableMappingSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        List<String> notPrimaryKeys = columns.stream().filter(col -> !primaryKeys.contains(col)).collect(Collectors.toList());
        List<String> columnsForUpdate = Stream.concat(notPrimaryKeys.stream(), primaryKeys.stream()).collect(Collectors.toList());
        String updateSql = "update " + tableName + TableMappingSqlFactory.createUpdateSetClause(notPrimaryKeys) + TableMappingSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        String deleteSql = "delete from " + tableName + TableMappingSqlFactory.createWhereClauseIdentifyByPrimaryKeys(primaryKeys);
        return new TableMappingSql(tableName, columns, primaryKeys, autoGeneratedColumns, notAutoGeneratedColumns, columnsForUpdate, hasPrimaryKey, hasAutoGeneratedColumns, insertOrMergePlaceholders, selectByPrimaryKeySql, selectAllSql, insertSql, updateSql, deleteSql, mergeSql, insertSqlPrefix, mergeSqlPrefix);
    }

    private static String toColumList(List<String> columns) {
        return String.join((CharSequence)",", columns);
    }

    private static String createUpdateSetClause(List<String> notPrimaryKeys) {
        return " set " + String.join((CharSequence)",", notPrimaryKeys.stream().map(npk -> npk + "=?").collect(Collectors.toList()));
    }

    private static String createWhereClauseIdentifyByPrimaryKeys(List<String> primaryKeys) {
        return " where " + String.join((CharSequence)" and ", primaryKeys.stream().map(pk -> pk + "=?").collect(Collectors.toList()));
    }

    private static String generatePlaceholders(int num) {
        return String.join((CharSequence)",", Stream.generate(() -> "?").limit(num).collect(Collectors.toList()));
    }
}

