/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import java.util.function.Function;
import org.nkjmlab.sorm4j.extension.Configurator;
import org.nkjmlab.sorm4j.extension.SormOptions;
import org.nkjmlab.sorm4j.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchOfMultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.SimpleBatchProcessor;

public final class MultiRowProcessorFactory {
    private final Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory;

    private MultiRowProcessorFactory(Function<TableMapping<?>, MultiRowProcessor<?>> multiRowProcessorFactory) {
        this.multiRowProcessorFactory = multiRowProcessorFactory;
    }

    public MultiRowProcessor<?> getMultiRowProcessor(TableMapping<?> tableMapping) {
        return this.multiRowProcessorFactory.apply(tableMapping);
    }

    public static MultiRowProcessorFactory createMultiRowProcessorFactory(SormOptions options, SqlParameterSetter sqlParameterSetter, Configurator.MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        switch (multiRowProcessorType) {
            case SIMPLE_BATCH: {
                return new MultiRowProcessorFactory(t -> new SimpleBatchProcessor(options, sqlParameterSetter, t, batchSize));
            }
            case MULTI_ROW: {
                return new MultiRowProcessorFactory(t -> new MultiRowInOneStatementProcessor(options, sqlParameterSetter, t, batchSize, multiRowSize));
            }
            case MULTI_ROW_AND_BATCH: {
                return new MultiRowProcessorFactory(t -> new BatchOfMultiRowInOneStatementProcessor(options, sqlParameterSetter, t, batchSize, multiRowSize, batchSizeWithMultiRow));
            }
        }
        return null;
    }
}

