/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.internal.util.SqlUtils;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.sql.SqlStatement;

public final class SqlStatementImpl
implements SqlStatement {
    private final String sql;
    private final Object[] parameters;
    private static final String LIST_PLACEHOLDER = "<?>";
    private static final String EMBEDDED_PLACEHOLDER = "$?$";

    private SqlStatementImpl(String sql, Object ... parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String toString() {
        return "sql=[" + this.sql + "]" + (String)(this.parameters == null || this.parameters.length == 0 ? "" : ", parameters=" + Arrays.toString(this.parameters));
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public final Object[] getParameters() {
        return this.parameters;
    }

    public static SqlStatement from(String sql, Object ... parameters) {
        SqlStatementImpl st = new SqlStatementImpl(sql, parameters);
        if (parameters.length == 0) {
            return st;
        }
        st = sql.contains(LIST_PLACEHOLDER) ? SqlStatementImpl.procListPlaceholder(sql, parameters) : st;
        st = sql.contains(EMBEDDED_PLACEHOLDER) ? SqlStatementImpl.procEmbeddedPlaceholder(st.getSql(), st.getParameters()) : st;
        return st;
    }

    private static SqlStatement procListPlaceholder(String sql, Object[] parameters) {
        List<Integer> specialParameterIndexes = SqlStatementImpl.createSpecialParameterIndexes(sql, '<', '?', '>');
        ArrayList<Object> flattenListParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (specialParameterIndexes.contains(i)) {
                Object o = parameters[i];
                if (o instanceof Collection) {
                    ((Collection)o).forEach(p -> flattenListParams.add(p));
                    continue;
                }
                if (o.getClass().isArray()) {
                    int length = Array.getLength(o);
                    for (int j = 0; j < length; ++j) {
                        Object elem = Array.get(o, j);
                        flattenListParams.add(elem);
                    }
                    continue;
                }
                throw new SormException("<?> parameter should be bind Collection or Array");
            }
            flattenListParams.add(parameters[i]);
        }
        String _sql = StringUtils.replacePlaceholder(sql, LIST_PLACEHOLDER, specialParameterIndexes.size(), index -> {
            int parameterLength = SqlStatementImpl.getSize(parameters[(Integer)specialParameterIndexes.get((int)index)]);
            return "?,".repeat(parameterLength).substring(0, 2 * parameterLength - 1);
        });
        return new SqlStatementImpl(_sql, flattenListParams.toArray());
    }

    private static int getSize(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        throw new SormException("<?> parameter should be bind Collection or Array");
    }

    private static SqlStatement procEmbeddedPlaceholder(String sql, Object[] parameters) {
        List<Integer> specialParameterIndexes = SqlStatementImpl.createSpecialParameterIndexes(sql, '$', '?', '$');
        ArrayList<Object> removedEmbeddedParams = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (specialParameterIndexes.contains(i)) continue;
            removedEmbeddedParams.add(parameters[i]);
        }
        String _sql = StringUtils.replacePlaceholder(sql, EMBEDDED_PLACEHOLDER, specialParameterIndexes.size(), index -> SqlUtils.literal(parameters[(Integer)specialParameterIndexes.get((int)index)]));
        return new SqlStatementImpl(_sql, removedEmbeddedParams.toArray());
    }

    private static List<Integer> createSpecialParameterIndexes(String str, char prefix, char normalPlaceholder, char suffix) {
        char[] arry = str.toCharArray();
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int parameterIndex = 0;
        for (int i = 0; i < arry.length; ++i) {
            char c = arry[i];
            if (c == normalPlaceholder && i - 1 >= 0 && arry[i - 1] == prefix && i + 1 < arry.length && arry[i + 1] == suffix) {
                ret.add(parameterIndex);
                ++parameterIndex;
                continue;
            }
            if (c != normalPlaceholder) continue;
            ++parameterIndex;
        }
        return ret;
    }
}

