/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class MethodInvoker {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public static String getSummary(int depth, String label) {
        StackTraceElement e = MethodInvoker.getStackTraceElement(depth);
        return dateTimeFormatter.format(LocalDateTime.now()) + " " + String.format("%5s", label) + " [" + Thread.currentThread().getName() + "] " + MethodInvoker.getInvokerClassName(e) + "." + MethodInvoker.getInvokerMethodName(e) + "(" + MethodInvoker.getInvokerFileName(e) + ":" + MethodInvoker.getInvokerLineNumber(e) + ")";
    }

    private static StackTraceElement getStackTraceElement(int index) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (index < 0) {
            return stackTrace[0];
        }
        if (index >= stackTrace.length) {
            return stackTrace[stackTrace.length - 1];
        }
        return stackTrace[index];
    }

    private static String getInvokerClassName(StackTraceElement e) {
        return e.getClassName() != null ? e.getClassName() : "";
    }

    private static String getInvokerMethodName(StackTraceElement e) {
        return e.getMethodName() != null ? e.getMethodName() : "";
    }

    private static String getInvokerFileName(StackTraceElement e) {
        return e.getFileName() != null ? e.getFileName() : "";
    }

    private static int getInvokerLineNumber(StackTraceElement e) {
        return e.getLineNumber();
    }
}

