package org.nkjmlab.sorm4j.internal.mapping;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Sqls generated by {@link TableMapping}.
 *
 * @author nkjm
 *
 */
public final class TableMappingSql {

  private static final Map<String, String> multiRowSqlMap = new ConcurrentHashMap<>();

  private final String tableName;

  private final List<String> columns;
  private final List<String> primaryKeys;
  private final String[] autoGeneratedColumns;
  private final List<String> notAutoGeneratedColumns;
  private final List<String> columnsForUpdate;

  private final boolean hasPrimaryKey;
  private final boolean hasAutoGeneratedColumns;

  private final String insertOrMergePlaceholders;

  private final String selectByPrimaryKeySql;
  private final String selectAllSql;
  private final String insertSql;
  private final String updateSql;
  private final String deleteSql;
  private final String mergeSql;
  private final String insertSqlPrefix;
  private final String mergeSqlPrefix;


  public TableMappingSql(String tableName, List<String> columns, List<String> primaryKeys,
      List<String> autoGeneratedColumns, List<String> notAutoGeneratedColumns,
      List<String> columnsForUpdate, boolean hasPrimaryKey, boolean hasAutoGeneratedColumns,
      String insertOrMergePlaceholders, String selectByPrimaryKeySql, String selectAllSql,
      String insertSql, String updateSql, String deleteSql, String mergeSql, String insertSqlPrefix,
      String mergeSqlPrefix) {
    this.tableName = tableName;
    this.columns = columns;
    this.primaryKeys = primaryKeys;
    this.autoGeneratedColumns = autoGeneratedColumns.toArray(String[]::new);
    this.notAutoGeneratedColumns = notAutoGeneratedColumns;
    this.columnsForUpdate = columnsForUpdate;
    this.hasPrimaryKey = hasPrimaryKey;
    this.hasAutoGeneratedColumns = hasAutoGeneratedColumns;
    this.insertOrMergePlaceholders = insertOrMergePlaceholders;
    this.selectByPrimaryKeySql = selectByPrimaryKeySql;
    this.selectAllSql = selectAllSql;
    this.insertSql = insertSql;
    this.updateSql = updateSql;
    this.deleteSql = deleteSql;
    this.mergeSql = mergeSql;
    this.insertSqlPrefix = insertSqlPrefix;
    this.mergeSqlPrefix = mergeSqlPrefix;
  }


  public String[] getAutoGeneratedColumns() {
    return autoGeneratedColumns;
  }

  public List<String> getColumns() {
    return columns;
  }

  public List<String> getColumnsForUpdate() {
    return columnsForUpdate;
  }

  public String getDeleteSql() {
    return deleteSql;
  }

  public String getInsertSql() {
    return insertSql;
  }

  public String getMergeSql() {
    return mergeSql;
  }


  public String getMultirowInsertSql(int num) {
    return getSqlWithMultirowPlaceholders(insertSqlPrefix, num);
  }

  public String getMultirowMergeSql(int num) {
    return getSqlWithMultirowPlaceholders(mergeSqlPrefix, num);
  }

  public List<String> getNotAutoGeneratedColumns() {
    return notAutoGeneratedColumns;
  }

  private String getSqlWithMultirowPlaceholders(String sqlPrefix, int num) {
    return multiRowSqlMap.computeIfAbsent(sqlPrefix + num, n -> sqlPrefix + String.join(",",
        Stream.generate(() -> insertOrMergePlaceholders).limit(num).collect(Collectors.toList())));
  }

  public List<String> getPrimaryKeys() {
    return primaryKeys;
  }

  public String getSelectAllSql() {
    return selectAllSql;
  }

  public String getSelectByPrimaryKeySql() {
    return selectByPrimaryKeySql;
  }

  public String getTableName() {
    return tableName;
  }

  public String getUpdateSql() {
    return updateSql;
  }

  public boolean hasAutoGeneratedColumns() {
    return hasAutoGeneratedColumns;
  }

  public boolean hasPrimaryKey() {
    return hasPrimaryKey;
  }


}

