package org.nkjmlab.sorm4j.sql;

import java.util.List;

/**
 * Represents a result from an insert operation with auto-generated keys.
 */
public interface InsertResult<T> {

  /**
   * Returns the row count by executing a insert statement
   * {@link java.sql.PreparedStatement#executeUpdate()}.
   */
  int[] getRowsModified();

  /**
   * Returns the object which insert last with auto-generated keys.
   *
   * @return
   */
  T getObject();

  /**
   * Returns auto-generated keys.
   *
   * @return
   */
  List<Object> getAutoGeneratedKeys();

}
