/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nkjmlab.sorm4j.SormException;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.Configurator;
import org.nkjmlab.sorm4j.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.extension.SqlParametersSetter;
import org.nkjmlab.sorm4j.extension.TableName;
import org.nkjmlab.sorm4j.extension.TableNameMapper;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.ConfiguratorImpl;
import org.nkjmlab.sorm4j.internal.mapping.Mappings;
import org.nkjmlab.sorm4j.internal.mapping.OrmCache;
import org.nkjmlab.sorm4j.internal.mapping.SormOptionsImpl;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.internal.util.StringUtils;

public final class ConfigStore {
    public static ConfigStore INITIAL_DEFAULT_CONFIG_STORE = new ConfiguratorImpl("DEFAULT_CONFIG").build();
    private final String configName;
    private final ColumnFieldMapper columnFieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetConverter resultSetConverter;
    private final SqlParametersSetter sqlParametersSetter;
    private final MultiRowProcessorFactory multiRowProcessorFactory;
    private final Configurator.MultiRowProcessorType multiRowProcessorType;
    private final int batchSize;
    private final int multiRowSize;
    private final int batchSizeWithMultiRow;
    private final int transactionIsolationLevel;
    private final Map<String, Object> options;
    private final Mappings mappings;
    private static final ConcurrentMap<String, ConfigStore> configStores = new ConcurrentHashMap<String, ConfigStore>();

    public ConfigStore(String cacheName, Map<String, Object> options, ColumnFieldMapper fieldNameMapper, TableNameMapper tableNameMapper, ResultSetConverter resultSetConverter, SqlParametersSetter sqlParametersSetter, Configurator.MultiRowProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow, int transactionIsolationLevel) {
        this.configName = cacheName;
        this.columnFieldMapper = fieldNameMapper;
        this.tableNameMapper = tableNameMapper;
        this.resultSetConverter = resultSetConverter;
        this.sqlParametersSetter = sqlParametersSetter;
        this.multiRowProcessorType = multiRowProcessorType;
        this.batchSize = batchSize;
        this.multiRowSize = multiRowSize;
        this.batchSizeWithMultiRow = batchSizeWithMultiRow;
        this.options = options;
        SormOptionsImpl _options = new SormOptionsImpl(options);
        this.multiRowProcessorFactory = MultiRowProcessorFactory.createMultiRowProcessorFactory(_options, sqlParametersSetter, multiRowProcessorType, batchSize, multiRowSize, batchSizeWithMultiRow);
        this.transactionIsolationLevel = transactionIsolationLevel;
        this.mappings = new Mappings(_options, tableNameMapper, fieldNameMapper, this.multiRowProcessorFactory, resultSetConverter, sqlParametersSetter, this.getTableMappings(), this.getColumnsMappings(), this.getClassNameToValidTableNameMap(), this.getTableNameToValidTableNameMaps());
    }

    public String getConfigName() {
        return this.configName;
    }

    public ColumnFieldMapper getColumnFieldMapper() {
        return this.columnFieldMapper;
    }

    public ResultSetConverter getResultSetConverter() {
        return this.resultSetConverter;
    }

    public TableNameMapper getTableNameMapper() {
        return this.tableNameMapper;
    }

    public MultiRowProcessorFactory getMultiRowProcessorFactory() {
        return this.multiRowProcessorFactory;
    }

    public SqlParametersSetter getSqlParametersSetter() {
        return this.sqlParametersSetter;
    }

    public ConcurrentMap<String, TableMapping<?>> getTableMappings() {
        return OrmCache.getTableMappings(this.configName);
    }

    public ConcurrentMap<Class<?>, ColumnsMapping<?>> getColumnsMappings() {
        return OrmCache.getColumnsMappings(this.configName);
    }

    public ConcurrentMap<Class<?>, TableName> getClassNameToValidTableNameMap() {
        return OrmCache.getClassNameToValidTableNameMap(this.configName);
    }

    public ConcurrentMap<String, TableName> getTableNameToValidTableNameMaps() {
        return OrmCache.getTableNameToValidTableNameMaps(this.configName);
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public static ConfigStore refreshAndRegister(ConfigStore configStore) {
        ConfigStore.refresh(configStore.getConfigName());
        configStores.put(configStore.getConfigName(), configStore);
        return configStore;
    }

    public static ConfigStore get(String configName) {
        ConfigStore ret = (ConfigStore)configStores.get(configName);
        if (ret != null) {
            return ret;
        }
        throw new SormException(StringUtils.format("Config name [{}] is not registered yet. Registered config names = {}", configName, configStores.keySet()));
    }

    public static ConfigStore getDefaultConfigStore() {
        return ConfigStore.get("DEFAULT_CONFIG");
    }

    public static void refresh(String configName) {
        OrmCache.refresh(configName);
    }

    public Configurator.MultiRowProcessorType getMultiRowProcessorType() {
        return this.multiRowProcessorType;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getMultiRowSize() {
        return this.multiRowSize;
    }

    public int getBatchSizeWithMultiRow() {
        return this.batchSizeWithMultiRow;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public String toString() {
        return "ConfigStore [configName=" + this.configName + ", columnFieldMapper=" + this.columnFieldMapper + ", tableNameMapper=" + this.tableNameMapper + ", resultSetConverter=" + this.resultSetConverter + ", sqlParametersSetter=" + this.sqlParametersSetter + ", multiRowProcessorType=" + this.multiRowProcessorType + ", batchSize=" + this.batchSize + ", multiRowSize=" + this.multiRowSize + ", batchSizeWithMultiRow=" + this.batchSizeWithMultiRow + ", transactionIsolationLevel=" + this.transactionIsolationLevel + "]";
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    static {
        configStores.put("DEFAULT_CONFIG", INITIAL_DEFAULT_CONFIG_STORE);
    }
}

