/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.extension.Accessor;
import org.nkjmlab.sorm4j.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.extension.Configurator;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.internal.sql.ParameterizedSqlImpl;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.ParameterizedSql;

public class NamedParameterSqlImpl
implements NamedParameterSql {
    private static final char DEFAULT_PREFIX = ':';
    private static final char DEFAULT_SUFFIX = '\u0000';
    private final String sql;
    private final char prefix;
    private final char suffix;
    private final ColumnFieldMapper columnFieldMapper;
    private final Map<String, Object> parameters;
    private Object bean;
    private static final Map<Class<?>, ColumnToAccessorMap> columnToAccessorMaps = new ConcurrentHashMap();

    public NamedParameterSqlImpl(String sql, char prefix, char suffix, ColumnFieldMapper columnFieldMapper) {
        this.sql = sql;
        this.prefix = prefix;
        this.suffix = suffix;
        this.columnFieldMapper = columnFieldMapper;
        this.parameters = new HashMap<String, Object>();
    }

    public NamedParameterSqlImpl(String sql) {
        this(sql, ':', '\u0000', Configurator.DEFAULT_COLUMN_FIELD_MAPPER);
    }

    @Override
    public NamedParameterSql bindAll(Map<String, Object> namedParams) {
        this.parameters.putAll(namedParams);
        return this;
    }

    @Override
    public NamedParameterSql bind(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    @Override
    public NamedParameterSql bindBean(Object bean) {
        this.bean = bean;
        return this;
    }

    @Override
    public ParameterizedSql parse() {
        TreeMap<Integer, Object> orderdParams = new TreeMap<Integer, Object>();
        String resultSql = this.sql;
        List<String> parameterNameList = this.createParameters();
        for (String parameterName : parameterNameList) {
            String namedPlaceholder = this.prefix + parameterName;
            namedPlaceholder = this.suffix != '\u0000' ? namedPlaceholder + this.suffix : namedPlaceholder;
            int pos = resultSql.indexOf(namedPlaceholder);
            if (pos == -1) continue;
            if (this.bean != null) {
                Accessor acc = this.getAccessor(parameterName);
                if (acc != null) {
                    orderdParams.put(pos, Try.getOrNull(() -> acc.get(this.bean)));
                }
                if (this.parameters.containsKey(parameterName)) {
                    orderdParams.put(pos, this.parameters.get(parameterName));
                }
                if (acc == null && !this.parameters.containsKey(parameterName)) continue;
                resultSql = resultSql.replaceAll(namedPlaceholder, "?");
                continue;
            }
            if (!this.parameters.containsKey(parameterName)) continue;
            orderdParams.put(pos, this.parameters.get(parameterName));
            resultSql = resultSql.replaceAll(namedPlaceholder, "?");
        }
        return ParameterizedSqlImpl.parse(resultSql, orderdParams.values().toArray());
    }

    private List<String> createParameters() {
        char[] arry = this.sql.toCharArray();
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < arry.length) {
            if (arry[i] == this.prefix) {
                char c;
                int j;
                for (j = i + 1; j < arry.length && this.isNamedParameterElement(c = arry[j]) && c != this.suffix; ++j) {
                }
                ret.add(this.sql.substring(i + 1, j));
                i = j + 1;
                continue;
            }
            ++i;
        }
        return ret;
    }

    private boolean isNamedParameterElement(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    private Accessor getAccessor(String parameterName) {
        Class<?> objectClass = this.bean.getClass();
        return columnToAccessorMaps.computeIfAbsent(objectClass, k -> new ColumnToAccessorMap(objectClass, this.columnFieldMapper.createAccessors(objectClass))).get(parameterName);
    }
}

