/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.sql.helper.SelectStringBuilder;

public class SelectStringBuilderImpl
implements SelectStringBuilder {
    private boolean distinct;
    private String columns = "*";
    private String table;
    private String where;
    private String groupBy;
    private String having;
    private String orderBy;
    private String limit;

    @Override
    public SelectStringBuilder select(String ... columns) {
        this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SelectStringBuilder distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public SelectStringBuilder from(String table) {
        this.table = table;
        return this;
    }

    @Override
    public SelectStringBuilder groupBy(String ... columns) {
        this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SelectStringBuilder having(SelectStringBuilder.Condition condition) {
        this.having(condition.toString());
        return this;
    }

    @Override
    public SelectStringBuilder having(String expr) {
        this.having = expr;
        return this;
    }

    @Override
    public SelectStringBuilder limit(int limit) {
        return this.limit(limit, 0);
    }

    @Override
    public SelectStringBuilder limit(int limit, int offset) {
        this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
        return this;
    }

    @Override
    public SelectStringBuilder orderBy(String column, String ascOrDesc) {
        this.orderBy(new SelectStringBuilder.OrderBy(column, ascOrDesc));
        return this;
    }

    @Override
    public SelectStringBuilder orderBy(SelectStringBuilder.OrderBy ... orderBys) {
        this.orderBy = String.join((CharSequence)", ", Arrays.stream(orderBys).map(ob -> ob.toString()).collect(Collectors.toList()));
        return this;
    }

    @Override
    public String build() {
        return this.toPrettyString(false);
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(true);
    }

    @Override
    public String toPrettyString(boolean prettyPrint) {
        StringBuilder sql = new StringBuilder("select ");
        if (this.distinct) {
            sql.append("distinct ");
        }
        sql.append(this.columns);
        sql.append(prettyPrint ? System.lineSeparator() : "");
        sql.append(" from " + this.table);
        if (this.where != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" where " + this.where);
        }
        if (this.groupBy != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" group by " + this.groupBy);
        }
        if (this.having != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" having " + this.having);
        }
        if (this.orderBy != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" order by " + this.orderBy);
        }
        if (this.limit != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" limit " + this.limit);
        }
        return sql.toString();
    }

    public String toString() {
        return this.toPrettyString(false);
    }

    @Override
    public SelectStringBuilder where(SelectStringBuilder.Condition condition) {
        this.where(condition.toString());
        return this;
    }

    @Override
    public SelectStringBuilder where(String expr) {
        this.where = expr;
        return this;
    }
}

