/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.internal.util.MethodInvoker;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.slf4j.Logger;

public final class LoggerFactory {
    private static final boolean enableLogger = LoggerFactory.isEnableSlf4j();
    private static final Map<Class<?>, Logger> loggers = new ConcurrentHashMap();

    private LoggerFactory() {
    }

    private static boolean isEnableSlf4j() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e1) {
            return false;
        }
    }

    public static Logger getLogger() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String className = stackTrace[1].getClassName();
        return org.slf4j.LoggerFactory.getLogger((String)className);
    }

    public static Logger getLogger(Class<?> clazz) {
        return loggers.computeIfAbsent(clazz, k -> org.slf4j.LoggerFactory.getLogger((Class)clazz));
    }

    public static void error(Class<?> clazz, String msg, Object ... params) {
        LoggerFactory.error(enableLogger, clazz, msg, params);
    }

    public static void error(boolean enableLogger, Class<?> clazz, String msg, Object ... params) {
        if (enableLogger) {
            LoggerFactory.getLogger(clazz).error(msg, params);
        } else {
            LoggerFactory.systemErrorPrintln("ERROR", StringUtils.format(msg, params));
        }
    }

    public static void warn(Class<?> clazz, String msg, Object ... params) {
        LoggerFactory.warn(enableLogger, clazz, msg, params);
    }

    public static void warn(boolean enableLogger, Class<?> clazz, String msg, Object ... params) {
        if (enableLogger) {
            LoggerFactory.getLogger(clazz).warn(msg, params);
        } else {
            LoggerFactory.systemErrorPrintln("WARN", StringUtils.format(msg, params));
        }
    }

    public static void info(Class<?> clazz, String msg, Object ... params) {
        LoggerFactory.info(enableLogger, clazz, msg, params);
    }

    public static void info(boolean enableLogger, Class<?> clazz, String msg, Object ... params) {
        if (enableLogger) {
            LoggerFactory.getLogger(clazz).info(msg, params);
        } else {
            LoggerFactory.systemOutPrintln("INFO", StringUtils.format(msg, params));
        }
    }

    public static void debug(Class<?> clazz, String msg, Object ... params) {
        LoggerFactory.debug(enableLogger, clazz, msg, params);
    }

    public static void debug(boolean enableLogger, Class<?> clazz, String msg, Object ... params) {
        if (enableLogger) {
            LoggerFactory.getLogger(clazz).debug(msg, params);
        } else {
            LoggerFactory.systemOutPrintln("DEBUG", StringUtils.format(msg, params));
        }
    }

    public static void trace(Class<?> clazz, String msg, Object ... params) {
        LoggerFactory.trace(enableLogger, clazz, msg, params);
    }

    public static void trace(boolean enableLogger, Class<?> clazz, String msg, Object ... params) {
        if (enableLogger) {
            LoggerFactory.getLogger(clazz).trace(msg, params);
        } else {
            LoggerFactory.systemOutPrintln("TRACE", StringUtils.format(msg, params));
        }
    }

    private static void systemErrorPrintln(String label, String msg) {
        System.err.println(MethodInvoker.getSummary(5, label) + " " + msg);
    }

    private static void systemOutPrintln(String label, String msg) {
        System.out.println(MethodInvoker.getSummary(5, label) + " " + msg);
    }
}

