/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql;

import java.util.Map;
import java.util.TreeMap;
import org.nkjmlab.sorm4j.annotation.Experimental;
import org.nkjmlab.sorm4j.internal.sql.ParameterizedSqlImpl;
import org.nkjmlab.sorm4j.internal.util.SqlUtils;
import org.nkjmlab.sorm4j.internal.util.StringUtils;
import org.nkjmlab.sorm4j.sql.NamedParameterSql;
import org.nkjmlab.sorm4j.sql.OrderedParameterSql;

public interface ParameterizedSql {
    public String getSql();

    public Object[] getParameters();

    @Experimental
    public String getBindedSql();

    @Experimental
    public static ParameterizedSql parse(String sql, Object ... parameters) {
        return OrderedParameterSql.parse(sql, parameters);
    }

    @Experimental
    public static ParameterizedSql parse(String sql, Map<String, Object> parameters) {
        return NamedParameterSql.parse(sql, parameters);
    }

    @Experimental
    public static String embededParameter(String sql, Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return sql;
        }
        return StringUtils.replacePlaceholder(sql, "{?}", parameters.length, index -> SqlUtils.literal(parameters[index]));
    }

    @Experimental
    public static String embededParameter(String sql, Map<String, Object> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return sql;
        }
        TreeMap orderdParams = new TreeMap();
        parameters.keySet().stream().forEach(key -> {
            int pos = sql.indexOf("{:" + key + "}");
            if (pos == -1) {
                return;
            }
            orderdParams.put(pos, parameters.get(key));
        });
        String _sql = sql.replaceAll("\\{:.*?\\}", "{?}");
        Object[] _params = orderdParams.values().toArray();
        return StringUtils.replacePlaceholder(_sql, "{?}", _params.length, index -> SqlUtils.literal(_params[index]));
    }

    public static ParameterizedSql from(String sql) {
        return ParameterizedSqlImpl.parse(sql, new Object[0]);
    }

    @Experimental
    public static String literal(Object element) {
        return SqlUtils.literal(element);
    }

    @Experimental
    public static String quote(String expr) {
        return SqlUtils.quote(expr);
    }
}

