/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.schema;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.annotation.Experimental;

@Experimental
public abstract class TableSchema {
    private final String name;
    private final Map<String, String[]> columnDefinitions;
    private final List<String[]> uniqueColumnPairs;
    private String[] primaryKeys;

    public TableSchema(String name) {
        this.name = name;
        this.columnDefinitions = new LinkedHashMap<String, String[]>();
        this.uniqueColumnPairs = new ArrayList<String[]>();
    }

    protected void addColumnDefinition(String columnName, String ... dataTypeAndOptions) {
        this.columnDefinitions.put(columnName, dataTypeAndOptions);
    }

    protected void addUniqueConstraint(String ... uniqueColumnPair) {
        this.uniqueColumnPairs.add(uniqueColumnPair);
    }

    public List<String> getColumnNames() {
        return TableSchemaGrammar.getColumunNames(this.columnDefinitions);
    }

    public String getName() {
        return this.name;
    }

    public String getTableSchema() {
        return TableSchemaGrammar.getTableSchema(this.getName(), this.columnDefinitions, this.primaryKeys, this.uniqueColumnPairs);
    }

    public String getIndexSchema(String ... columns) {
        String indexName = "index_" + this.name + "_" + String.join((CharSequence)"_", columns);
        return IndexSchemaGrammar.createIndexOn(indexName, this.name, columns);
    }

    protected void setPrimaryKey(String ... attributes) {
        this.primaryKeys = attributes;
    }

    protected static interface TableSchemaKeyword {
        public static final String VARCHAR = "VARCHAR";
        public static final String CHAR = "CHAR";
        public static final String DATE = "DATE";
        public static final String TIME = "TIME";
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String TIMESTAMP_AS_CURRENT_TIMESTAMP = "TIMESTAMP AS CURRENT_TIMESTAMP";
        public static final String REAL = "REAL";
        public static final String DOUBLE = "DOUBLE";
        public static final String BIGINT = "BIGINT";
        public static final String INT = "INT";
        public static final String BOOLEAN = "BOOLEAN";
        public static final String DECIMAL = "DECIMAL";
        public static final String TINYINT = "TINYINT";
        public static final String SMALLINT = "SMALLINT";
        public static final String IDENTITY = "IDENTITY";
        public static final String UNIQUE = "UNIQUE";
        public static final String NOT_NULL = "NOT NULL";
        public static final String PRIMARY_KEY = "PRIMARY KEY";
        public static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    }

    protected static interface TableSchemaGrammar {
        private static String createPrimaryKeyConstraint(String[] primaryKeys) {
            if (primaryKeys == null || primaryKeys.length == 0) {
                return "";
            }
            return ", primary key" + GrammarUtils.wrapParentheses(GrammarUtils.joinCommaAndSpace(primaryKeys));
        }

        private static String createUniqueConstraint(List<String[]> uniqueColumnPairs) {
            if (uniqueColumnPairs == null || uniqueColumnPairs.size() == 0) {
                return "";
            }
            return ", " + GrammarUtils.joinCommaAndSpace((String[])uniqueColumnPairs.stream().map(u -> "unique" + GrammarUtils.wrapParentheses(GrammarUtils.joinCommaAndSpace(u))).toArray(String[]::new));
        }

        private static List<String> getColumunNames(Map<String, String[]> columnDefinitions) {
            return columnDefinitions.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        private static String getTableSchema(String tableName, Map<String, String[]> columns, String[] primaryKeys, List<String[]> uniqueColumnPairs) {
            String schema = tableName + GrammarUtils.wrapParentheses(GrammarUtils.joinCommaAndSpace(TableSchemaGrammar.getColumuns(columns)) + TableSchemaGrammar.createPrimaryKeyConstraint(primaryKeys) + TableSchemaGrammar.createUniqueConstraint(uniqueColumnPairs));
            return schema;
        }

        private static List<String> getColumuns(Map<String, String[]> columnDefinisions) {
            return columnDefinisions.keySet().stream().map(columnName -> columnName + " " + GrammarUtils.joinSpace((String[])columnDefinisions.get(columnName))).collect(Collectors.toList());
        }
    }

    protected static class IndexSchemaGrammar {
        protected IndexSchemaGrammar() {
        }

        private static String createIndexOn(String indexName, String tableName, String ... columns) {
            return "create index if not exists " + indexName + " on " + tableName + GrammarUtils.wrapParentheses(GrammarUtils.joinCommaAndSpace(columns));
        }
    }

    protected static interface GrammarUtils {
        public static String joinCommaAndSpace(String ... elements) {
            return String.join((CharSequence)", ", elements);
        }

        public static String joinSpace(String ... elements) {
            return String.join((CharSequence)" ", elements);
        }

        public static String joinCommaAndSpace(List<String> elements) {
            return String.join((CharSequence)", ", elements);
        }

        public static String wrapParentheses(String str) {
            return "(" + str + ")";
        }
    }
}

