package org.nkjmlab.sorm4j.extension;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.internal.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.internal.mapping.TableMapping;


/**
 * A mapper from column to field name.
 *
 * @author nkjm
 *
 */
public interface ColumnFieldMapper {

  /**
   *
   * Retrieves a list of auto-generated columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<ColumnName> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName)
      throws SQLException;

  /**
   * Gets column names of the given table name of the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */
  List<ColumnName> getColumns(DatabaseMetaData metaData, String tableName) throws SQLException;

  /**
   *
   * Retrieves a list of primary keys columns of the given table name from the database metadata.
   *
   * @param metaData
   * @param tableName
   * @return
   * @throws SQLException
   */

  List<ColumnName> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException;



  /**
   * Creates accessors by guessing column names from the object class for {@link TableMapping}
   * @param objectClass
   * @param columnNames
   *
   * @return
   */
  Map<String, Accessor> createAccessors(Class<?> objectClass, List<ColumnName> columnNames);

  /**
   * Creates accessors by guessing column names from the object class for {@link ColumnsMapping}
   *
   * @param objectClass
   * @return
   */

  Map<String, Accessor> createAccessors(Class<?> objectClass);


}
