/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.nkjmlab.sorm4j.internal.util.LogPoint;

public final class LoggerConfig {
    private final Map<Category, Boolean> modes = new EnumMap<Category, Boolean>(Category.class);

    public LoggerConfig() {
        this.on(Category.MAPPING);
    }

    public void on(Category ... categories) {
        Arrays.stream(categories).forEach(name -> this.modes.put((Category)((Object)name), true));
    }

    public void off(Category ... categories) {
        Arrays.stream(categories).forEach(name -> this.modes.put((Category)((Object)name), false));
    }

    public void onAll() {
        this.on(Category.values());
    }

    public void offAll() {
        this.off(Category.values());
    }

    public Optional<LogPoint> createLogPoint(Category category) {
        Boolean f = this.modes.get((Object)category);
        if (f == null || !f.booleanValue()) {
            return Optional.empty();
        }
        LogPoint dp = new LogPoint(category.name());
        return Optional.of(dp);
    }

    public static enum Category {
        MAPPING,
        EXECUTE_QUERY,
        MULTI_ROW,
        EXECUTE_UPDATE,
        HANDLE_PREPAREDSTATEMENT;

    }
}

